/*
 * ************* DO NOT EDIT THIS FILE ***********
 *
 * This file was automatically generated from nsIServiceManager.idl.
 */


package org.mozilla.xpcom;


/**
 * Interface nsIServiceManager
 *
 * IID: 0x8bb35ed9-e332-462d-9155-4a002ab5c958
 */

/**
 * The nsIServiceManager manager interface provides a means to obtain
 * global services in an application. The service manager depends on the 
 * repository to find and instantiate factories to obtain services.
 *
 * Users of the service manager must first obtain a pointer to the global
 * service manager by calling NS_GetServiceManager. After that, 
 * they can request specific services by calling GetService. When they are
 * finished they can NS_RELEASE() the service as usual.
 *
 * A user of a service may keep references to particular services indefinitely
 * and only must call Release when it shuts down.
 *
 * @status FROZEN
 */
public interface nsIServiceManager extends nsISupports
{
    public static final IID IID =
       new IID("8bb35ed9-e332-462d-9155-4a002ab5c958");

    /**
     * getServiceByContractID
     *
     * Returns the instance that implements aClass or aContractID and the
     * interface aIID.  This may result in the instance being created.
     *
     * @param aClass or aContractID : aClass or aContractID of object 
     *                                instance requested
     * @param aIID : IID of interface requested
     * @param result : resulting service 
     */

    /* void getService (in nsCIDRef aClass, in nsIIDRef aIID, [iid_is (aIID), retval] out nsQIResult result); */
    public Object getService(CID aClass, IID aIID);

    /* void getServiceByContractID (in string aContractID, in nsIIDRef aIID, [iid_is (aIID), retval] out nsQIResult result); */
    public Object getServiceByContractID(String aContractID, IID aIID);
    /**
     * isServiceInstantiated
     *
     * isServiceInstantiated will return a true if the service has already
     * been created, otherwise false
     *
     * @param aClass or aContractID : aClass or aContractID of object 
     *                                instance requested
     * @param aIID : IID of interface requested
     * @param aIID : IID of interface requested
     */

    /* boolean isServiceInstantiated (in nsCIDRef aClass, in nsIIDRef aIID); */
    public boolean isServiceInstantiated(CID aClass, IID aIID);

    /* boolean isServiceInstantiatedByContractID (in string aContractID, in nsIIDRef aIID); */
    public boolean isServiceInstantiatedByContractID(String aContractID, IID aIID);

}

/*
 * end
 */
