
;;; d-css.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-css.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Cascading Style Sheets (C.S.S.) code
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(setq auto-mode-alist
      (append
             '(
               ("\\.css$". css-mode)
              )
      auto-mode-alist))

(defun css-mode ()
  (interactive)
  (java-mode)
  (setq tab-width 3)
  (setq major-mode 'css-mode)
  (setq mode-name "CSS")
  (setq indent-tabs-mode nil)
  (d-font-lock-add-end
   '(
     ("#[a-zA-Z0-9-]+" 0 'font-lock-preprocessor-face t)
     ("#[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]\\>" 0 'd-face-cc-digits t)
     ("#[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]\\>" 0 'd-face-cc-digits t)
     ("url(\\([^()]*\\))" 1 'fg:lightblue nil)
     )))

;;(require 'd-flock)
(provide 'd-css)
