
;; (d-print-list '("abc" "def"))
(defun d-print-list (list)
  (let ((ptr    list)
        (result "")
        (s      nil))
    (while ptr
      (setq s (prin1-to-string (car ptr)))
      (setq result (concat (substring s 1 (1- (length s))) ", " result))
      (setq ptr (cdr ptr)))
    (aset result (- (length result) 2) ? )
    result))

;; (d-find-makefile "~/c++-projects/2008/tests")
;; (d-find-makefile "~/dlisp/")
(defun d-find-makefile (f &optional silent)
  ;;(debug)
  (let* ((f      (expand-file-name f))
         (f-list (list f))
         (f-old  nil))
    ;;(debug)
    (while (and (not (string= f-old f)) (not (file-exists-p (concat f "/Makefile"))))
      ;;(message "testing f=%s" f)
      (setq f-old f)
      (setq f (expand-file-name (concat f "/..")))
      (setq f-list (cons f f-list)))
    (if (not (file-exists-p (concat f "/Makefile")))
        (if (not silent) (error "Makefile not found in dirs %s" (d-print-list (cdr f-list))) nil)
      f)))

;;(message "found makefile at %s" f)
;; (message "no makefile found at %s" f)))

;;
;; (d-editing "\\.jtw$")
;;
(defun d-editing (regexp)
  (let* ((list (buffer-list))
         (ptr  list)
         (done nil)
         (name nil))
    (while (and ptr (not done))
      (setq name (buffer-file-name (car ptr)))
      (if (and name (string-match regexp name))
          (setq done t)
        (setq ptr (cdr ptr))))
    ;;(debug)
    (car ptr)))

(defun d-check-for-jtw-includes ()
  (let ((buf (d-editing "\\.jtw$")))
    (if buf
        (save-excursion
          (set-buffer buf)
          (goto-char (point-min))
          (if (not (re-search-forward "m4_include(readonly.m4)" nil t))
              (error "The first line in file %s must be: m4_include(readonly.m4)"
                     (file-name-nondirectory (buffer-file-name buf))))))))

(defadvice d-f9 (around d-setdir activate)
  (if (not (string= (buffer-name) "*compilation*"))
      (other-window 1))
  ;;(d-check-for-jtw-includes)
  (setq d (d-find-makefile default-directory))
  (if d (dired d))
  ;;  (if (string-match (concat "^" (getenv "HOME") "/[0-9]+-[^/]*/") (expand-file-name default-directory))
  ;;      (dired (substring (expand-file-name default-directory) (match-beginning 0) (match-end 0))))
  ;;  (if (string-match (concat "^" (getenv "HOME") "/cosc327-assignment/classes/") (expand-file-name default-directory))
  ;;      (dired (concat (getenv "HOME") "cosc327-assignment")))
  (delete-other-windows)
  ad-do-it
  ;;(f9--set-dir-name)
  )

(defadvice d-shift-f9 (around d-setdir activate)
  ;;(d-check-for-jtw-includes)
  (if (not (string= (buffer-name) "*compilation*"))
      (other-window 1))
  (setq d (d-find-makefile default-directory))
  (if d (dired d))
  ;;(if (string-match (concat "^" (getenv "HOME") "/[0-9]+-[^/]*/") (expand-file-name default-directory))
  ;;(dired (substring (expand-file-name default-directory) (match-beginning 0) (match-end 0))))
  ;;(if (string-match (concat "^" (getenv "HOME") "/cosc327-assignment/classes/") (expand-file-name default-directory))
  ;;dired (concat (getenv "HOME") "cosc327-assignment")))
  ad-do-it
  ;;(setq dir-name nil)
  ;;(d-foo)
  ;;(f9--set-dir-name)
  )

(provide 'd-setdir)
;;; d-setdir.el ends here
