/* kw.h - interface to kw.c
   Copyright (C) 2000 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

/* Written by Marc Tardif <intmktg@cam.org>.  */

#ifndef KW_H
#define KW_H

#define MAX_DEPTH 3

/* Supported file formats.                                               */
enum extension
{
  TEXT,
  HTML
};

/* Syntax tree representating a boolean expression.                      */
struct tree
{
  void *left;                    /* Left link or beginning of pattern.   */
  void *right;                   /* Right link or end of pattern.        */
  int value;                     /* Value of boolean operator or index.  */
};

/* Attributes retained for each pattern.                                 */
struct pat
{
  char **line;                   /* Context lines for each pattern.      */
  char *str;                     /* Pointer to pattern in argv.          */
  int *distance;                 /* Array of distances between patterns. */
  int position;                  /* Position of last occurence.          */
  int count;                     /* Number of occurences.                */
  int len;                       /* Length of pattern.                   */
};

/* Structure containing everything.                                      */
struct kw
{
  struct tree *tree;             /* Top of the syntax tree.              */
  struct pat *pat;               /* Dynamic array of patterns.           */
  unsigned char **context_table; /* Context state table.                 */
  unsigned char *cstack[MAX_DEPTH]; /* Stack of context states.          */
  unsigned char **pattern_table; /* Pattern state table.                 */
  unsigned char *pstack[MAX_DEPTH]; /* Stack of pattern states.          */
  char *str;                     /* Temporary string buffer.             */
  int bpos, fpos;                /* Positions in str buffer.             */
  int num;                       /* Number of patterns in expression.    */
  int state;                     /* State of keyword set.                */
  int words;                     /* Total word count.                    */
};

extern struct kw *kw;
extern int  kw_init (char *);
extern void kw_prep (enum extension);
extern int  kw_exec (char **, char **, char *);
extern int  kw_print (void);
extern void kw_free (void);

#endif
