/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.rules;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.rules.AbstractDesignerRule;
import org.eclipse.wb.internal.core.model.order.MethodOrder;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.xml.sax.Attributes;

public final class MethodOrderMethodsRule
extends AbstractDesignerRule {
    private MethodOrder m_order;
    private List<String> m_signatures;

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        String specification = MethodOrderMethodsRule.getRequiredAttribute(name, attributes, "order");
        this.m_order = MethodOrder.parse(specification);
        this.m_signatures = Lists.newArrayList();
        this.getDigester().push(this.m_signatures);
    }

    public void end(String namespace, String name) throws Exception {
        this.getDigester().pop();
        ComponentDescription componentDescription = (ComponentDescription)this.getDigester().peek();
        for (String signature : this.m_signatures) {
            MethodDescription methodDescription = componentDescription.getMethod(signature);
            Assert.isNotNull((Object)methodDescription, (String)"Can not find method %s for %s.", (Object[])new Object[]{signature, componentDescription});
            methodDescription.setOrder(this.m_order);
        }
        this.m_order = null;
        this.m_signatures = null;
    }
}

