"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getWorkspaceFolder = exports.createServiceEnvironment = exports.createSimpleProjectProvider = void 0;
const vscode_uri_1 = require("vscode-uri");
const uriMap_1 = require("../utils/uriMap");
const simpleProject_1 = require("./simpleProject");
function createSimpleProjectProvider(languagePlugins) {
    const map = (0, uriMap_1.createUriMap)();
    return {
        get(uri) {
            const workspaceFolder = getWorkspaceFolder(vscode_uri_1.URI.parse(uri), this.workspaceFolders);
            let projectPromise = map.get(workspaceFolder);
            if (!projectPromise) {
                const serviceEnv = createServiceEnvironment(this, workspaceFolder);
                projectPromise = (0, simpleProject_1.createSimpleServerProject)(this, serviceEnv, languagePlugins);
                map.set(workspaceFolder, projectPromise);
            }
            return projectPromise;
        },
        async all() {
            return await Promise.all([...map.values()]);
        },
        reload() {
            for (const project of map.values()) {
                project.then(p => p.dispose());
            }
            map.clear();
        },
    };
}
exports.createSimpleProjectProvider = createSimpleProjectProvider;
function createServiceEnvironment(server, workspaceFolder) {
    return {
        workspaceFolder: workspaceFolder.toString(),
        fs: server.fs,
        locale: server.initializeParams?.locale,
        clientCapabilities: server.initializeParams?.capabilities,
        getConfiguration: server.getConfiguration,
        onDidChangeConfiguration: server.onDidChangeConfiguration,
        onDidChangeWatchedFiles: server.onDidChangeWatchedFiles,
        typescript: {
            fileNameToUri: server.uriConverter.fileNameToUri,
            uriToFileName: server.uriConverter.uriToFileName,
        },
    };
}
exports.createServiceEnvironment = createServiceEnvironment;
function getWorkspaceFolder(uri, workspaceFolders) {
    while (true) {
        if (workspaceFolders.has(uri)) {
            return uri;
        }
        const next = uri.with({ path: uri.path.substring(0, uri.path.lastIndexOf('/')) });
        if (next.path === uri.path) {
            break;
        }
        uri = next;
    }
    for (const folder of workspaceFolders.keys()) {
        return folder;
    }
    return uri.with({ path: '/' });
}
exports.getWorkspaceFolder = getWorkspaceFolder;
//# sourceMappingURL=simpleProjectProvider.js.map