/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.impl.ExecutorManager;
import com.hazelcast.impl.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.util.HealthMonitorLevel;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class HealthMonitor
extends Thread {
    private final ILogger logger;
    private final Node node;
    private final Runtime runtime;
    private final OperatingSystemMXBean osMxBean;
    private final HealthMonitorLevel logLevel;
    private final int delaySeconds;
    private final ThreadMXBean threadMxBean;
    private double treshold = 70.0;
    private static final String[] UNITS = new String[]{"", "K", "M", "G", "T", "P", "E"};

    public HealthMonitor(Node node, HealthMonitorLevel logLevel, int delaySeconds) {
        super(node.threadGroup, node.getThreadNamePrefix("HealthMonitor"));
        this.setDaemon(true);
        this.delaySeconds = delaySeconds;
        this.node = node;
        this.logger = node.getLogger(HealthMonitor.class.getName());
        this.runtime = Runtime.getRuntime();
        this.osMxBean = ManagementFactory.getOperatingSystemMXBean();
        this.logLevel = logLevel;
        this.threadMxBean = ManagementFactory.getThreadMXBean();
    }

    public void run() {
        if (this.logLevel == HealthMonitorLevel.OFF) {
            return;
        }
        while (this.node.isActive()) {
            switch (this.logLevel) {
                case NOISY: {
                    HealthMetrics metrics = new HealthMetrics();
                    this.logger.log(Level.INFO, metrics.toString());
                    break;
                }
                case SILENT: {
                    HealthMetrics metrics = new HealthMetrics();
                    if (!metrics.exceedsTreshold()) break;
                    this.logger.log(Level.INFO, metrics.toString());
                    break;
                }
                default: {
                    throw new IllegalStateException("unrecognized logLevel:" + (Object)((Object)this.logLevel));
                }
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.delaySeconds));
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private static Long get(OperatingSystemMXBean mbean, String methodName, Long defaultValue) {
        try {
            Method method = mbean.getClass().getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            Object value = method.invoke((Object)mbean, new Object[0]);
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Integer) {
                return (long)((Integer)value);
            }
            if (value instanceof Double) {
                double v = (Double)value;
                return Math.round(v * 100.0);
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String percentageString(double p) {
        return String.format("%.2f", p) + "%";
    }

    public static String bytesToString(long bytes) {
        for (int i = 6; i > 0; --i) {
            double step = Math.pow(1024.0, i);
            if (!((double)bytes > step)) continue;
            return String.format("%3.1f%s", (double)bytes / step, UNITS[i]);
        }
        return Long.toString(bytes);
    }

    public class HealthMetrics {
        final long memoryFree;
        final long memoryTotal;
        final long memoryUsed;
        final long memoryMax;
        final double memoryUsedOfTotalPercentage;
        final double memoryUsedOfMaxPercentage;
        final double processCpuLoad;
        final double systemLoadAverage;
        final double systemCpuLoad;
        final int packetQueueSize;
        final int processableQueueSize;
        final int processablePriorityQueueSize;
        final int threadCount;
        final int peakThreadCount;
        final int queryQueueSize;
        final int mapLoaderExecutorQueueSize;
        final int defaultExecutorQueueSize;
        final int asyncExecutorQueueSize;
        final int eventExecutorQueueSize;
        final int mapStoreExecutorQueueSize;

        public HealthMetrics() {
            this.memoryFree = HealthMonitor.this.runtime.freeMemory();
            this.memoryTotal = HealthMonitor.this.runtime.totalMemory();
            this.memoryUsed = this.memoryTotal - this.memoryFree;
            this.memoryMax = HealthMonitor.this.runtime.maxMemory();
            this.memoryUsedOfTotalPercentage = 100.0 * (double)this.memoryUsed / (double)this.memoryTotal;
            this.memoryUsedOfMaxPercentage = 100.0 * (double)this.memoryUsed / (double)this.memoryMax;
            this.processCpuLoad = HealthMonitor.get(HealthMonitor.this.osMxBean, "getProcessCpuLoad", -1L).longValue();
            this.systemLoadAverage = HealthMonitor.get(HealthMonitor.this.osMxBean, "getSystemLoadAverage", -1L).longValue();
            this.systemCpuLoad = HealthMonitor.get(HealthMonitor.this.osMxBean, "getSystemCpuLoad", -1L).longValue();
            ClusterService clusterService = HealthMonitor.this.node.getClusterService();
            this.packetQueueSize = clusterService.getPacketQueueSize();
            this.processableQueueSize = clusterService.getProcessableQueueSize();
            this.processablePriorityQueueSize = clusterService.getProcessablePriorityQueueSize();
            this.threadCount = HealthMonitor.this.threadMxBean.getThreadCount();
            this.peakThreadCount = HealthMonitor.this.threadMxBean.getPeakThreadCount();
            ExecutorManager.Statistics statistics = HealthMonitor.this.node.getExecutorManager().getStatistics();
            this.queryQueueSize = statistics.queryQueueSize;
            this.mapLoaderExecutorQueueSize = statistics.mapLoaderExecutorQueueSize;
            this.defaultExecutorQueueSize = statistics.defaultExecutorQueueSize;
            this.asyncExecutorQueueSize = statistics.asyncExecutorQueueSize;
            this.eventExecutorQueueSize = statistics.eventExecutorQueueSize;
            this.mapStoreExecutorQueueSize = statistics.mapStoreExecutorQueueSize;
        }

        public boolean exceedsTreshold() {
            if (this.memoryUsedOfMaxPercentage > HealthMonitor.this.treshold) {
                return true;
            }
            if (this.processCpuLoad > HealthMonitor.this.treshold) {
                return true;
            }
            if (this.systemCpuLoad > HealthMonitor.this.treshold) {
                return true;
            }
            return this.systemCpuLoad > HealthMonitor.this.treshold;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("memory.used=").append(HealthMonitor.bytesToString(this.memoryUsed)).append(", ");
            sb.append("memory.free=").append(HealthMonitor.bytesToString(this.memoryFree)).append(", ");
            sb.append("memory.total=").append(HealthMonitor.bytesToString(this.memoryTotal)).append(", ");
            sb.append("memory.max=").append(HealthMonitor.bytesToString(this.memoryMax)).append(", ");
            sb.append("memory.used/total=").append(HealthMonitor.percentageString(this.memoryUsedOfTotalPercentage)).append(" ");
            sb.append("memory.used/max=").append(HealthMonitor.percentageString(this.memoryUsedOfMaxPercentage)).append(" ");
            sb.append("load.process=").append(String.format("%.2f", this.processCpuLoad)).append("%, ");
            sb.append("load.system=").append(String.format("%.2f", this.systemCpuLoad)).append("%, ");
            sb.append("load.systemAverage=").append(String.format("%.2f", this.systemLoadAverage)).append("% ");
            sb.append("q.packet.size=").append(this.packetQueueSize).append(", ");
            sb.append("q.processable.size=").append(this.processableQueueSize).append(", ");
            sb.append("q.processablePriority.size=").append(this.processablePriorityQueueSize).append(", ");
            sb.append("thread.count=").append(this.threadCount).append(", ");
            sb.append("thread.peakCount=").append(this.peakThreadCount).append(", ");
            sb.append("q.query.size=").append(this.queryQueueSize).append(", ");
            sb.append("q.mapLoader.size=").append(this.mapLoaderExecutorQueueSize).append(", ");
            sb.append("q.defaultExecutor.size=").append(this.defaultExecutorQueueSize).append(", ");
            sb.append("q.asyncExecutor.size=").append(this.asyncExecutorQueueSize).append(", ");
            sb.append("q.eventExecutor.size=").append(this.eventExecutorQueueSize).append(", ");
            sb.append("q.mapStoreExecutor.size=").append(this.mapStoreExecutorQueueSize);
            return sb.toString();
        }
    }
}

