/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VertxException;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.spi.Action;
import org.vertx.java.core.spi.cluster.ClusterManager;
import org.vertx.java.core.spi.cluster.NodeListener;
import org.vertx.java.platform.impl.Deployment;
import org.vertx.java.platform.impl.PlatformManagerInternal;

public class HAManager {
    private static final Logger log = LoggerFactory.getLogger(HAManager.class);
    private static final String CLUSTER_MAP_NAME = "__vertx.haInfo";
    private static final long QUORUM_CHECK_PERIOD = 1000L;
    private final VertxInternal vertx;
    private final PlatformManagerInternal platformManager;
    private final ClusterManager clusterManager;
    private final int quorumSize;
    private final String group;
    private final JsonObject haInfo;
    private final JsonArray haMods;
    private final Map<String, String> clusterMap;
    private final String nodeID;
    private final Queue<Runnable> toDeployOnQuorum = new ConcurrentLinkedQueue<Runnable>();
    private long quorumTimerID;
    private volatile boolean attainedQuorum;
    private volatile Handler<Boolean> failoverCompleteHandler;
    private volatile boolean failDuringFailover;
    private volatile boolean stopped;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HAManager(VertxInternal vertx, PlatformManagerInternal platformManager, ClusterManager clusterManager, int quorumSize, String group) {
        this.vertx = vertx;
        this.platformManager = platformManager;
        this.clusterManager = clusterManager;
        this.quorumSize = quorumSize;
        this.group = group == null ? "__DEFAULT__" : group;
        this.haInfo = new JsonObject();
        this.haMods = new JsonArray();
        this.haInfo.putArray("mods", this.haMods);
        this.haInfo.putString("group", this.group);
        this.clusterMap = clusterManager.getSyncMap(CLUSTER_MAP_NAME);
        this.nodeID = clusterManager.getNodeID();
        clusterManager.nodeListener(new NodeListener(){

            public void nodeAdded(String nodeID) {
                HAManager.this.nodeAdded(nodeID);
            }

            public void nodeLeft(String leftNodeID) {
                HAManager.this.nodeLeft(leftNodeID);
            }
        });
        this.clusterMap.put(this.nodeID, this.haInfo.encode());
        this.quorumTimerID = vertx.setPeriodic(1000L, (Handler)new Handler<Long>(){

            public void handle(Long timerID) {
                HAManager.this.checkHADeployments();
            }
        });
        HAManager hAManager = this;
        synchronized (hAManager) {
            this.checkQuorum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromHA(String depID) {
        JsonArray jsonArray = this.haMods;
        synchronized (jsonArray) {
            Iterator iter = this.haMods.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                JsonObject mod = (JsonObject)obj;
                if (!mod.getString("dep_id").equals(depID)) continue;
                iter.remove();
            }
        }
        this.clusterMap.put(this.nodeID, this.haInfo.encode());
    }

    public void deployModule(final String moduleName, final JsonObject config, final int instances, final Handler<AsyncResult<String>> doneHandler) {
        if (this.attainedQuorum) {
            Handler<AsyncResult<String>> wrappedHandler = new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> asyncResult) {
                    if (asyncResult.succeeded()) {
                        HAManager.this.addToHA((String)asyncResult.result(), moduleName, config, instances);
                    }
                    if (doneHandler != null) {
                        doneHandler.handle(asyncResult);
                    } else if (asyncResult.failed()) {
                        log.error((Object)"Failed to deploy module", asyncResult.cause());
                    }
                }
            };
            this.platformManager.deployModuleInternal(moduleName, config, instances, true, wrappedHandler);
        } else {
            log.info((Object)"Quorum not attained. Deployment of module will be delayed until there's a quorum.");
            this.addToHADeployList(moduleName, config, instances, doneHandler);
        }
    }

    public void stop() {
        if (!this.stopped) {
            this.clusterMap.remove(this.nodeID);
            this.vertx.cancelTimer(this.quorumTimerID);
            this.stopped = true;
        }
    }

    public void simulateKill() {
        if (!this.stopped) {
            this.clusterManager.leave();
            this.vertx.cancelTimer(this.quorumTimerID);
            this.stopped = true;
        }
    }

    public void failoverCompleteHandler(Handler<Boolean> failoverCompleteHandler) {
        this.failoverCompleteHandler = failoverCompleteHandler;
    }

    public void failDuringFailover(boolean fail) {
        this.failDuringFailover = fail;
    }

    private synchronized void nodeAdded(String nodeID) {
        this.checkQuorumWhenAdded(nodeID, System.currentTimeMillis());
    }

    private synchronized void nodeLeft(String leftNodeID) {
        this.checkQuorum();
        if (this.attainedQuorum) {
            String sclusterInfo = this.clusterMap.get(leftNodeID);
            if (sclusterInfo != null) {
                this.checkFailover(leftNodeID, new JsonObject(sclusterInfo));
            }
            List nodes = this.clusterManager.getNodes();
            for (Map.Entry<String, String> entry : this.clusterMap.entrySet()) {
                if (nodes.contains(entry.getKey())) continue;
                this.checkFailover(entry.getKey(), new JsonObject(entry.getValue()));
            }
        }
    }

    private synchronized void checkQuorumWhenAdded(final String nodeID, final long start) {
        if (this.clusterMap.containsKey(nodeID)) {
            this.checkQuorum();
        } else {
            this.vertx.setTimer(200L, (Handler)new Handler<Long>(){

                public void handle(Long event) {
                    HAManager.this.vertx.executeBlocking((Action)new Action<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Void perform() {
                            if (System.currentTimeMillis() - start > 10000L) {
                                log.warn((Object)"Timed out waiting for group information to appear");
                            } else if (!HAManager.this.stopped) {
                                DefaultContext context = HAManager.this.vertx.getContext();
                                try {
                                    HAManager.this.vertx.setContext(null);
                                    HAManager.this.checkQuorumWhenAdded(nodeID, start);
                                }
                                finally {
                                    HAManager.this.vertx.setContext(context);
                                }
                            }
                            return null;
                        }
                    }, null);
                }
            });
        }
    }

    private void checkQuorum() {
        boolean attained;
        List nodes = this.clusterManager.getNodes();
        int count = 0;
        for (String node : nodes) {
            JsonObject clusterInfo;
            String group;
            String json = this.clusterMap.get(node);
            if (json == null || !(group = (clusterInfo = new JsonObject(json)).getString("group")).equals(this.group)) continue;
            ++count;
        }
        boolean bl = attained = count >= this.quorumSize;
        if (!this.attainedQuorum && attained) {
            log.info((Object)"A quorum has been obtained. Any deployments waiting on a quorum will now be deployed");
            this.attainedQuorum = true;
        } else if (this.attainedQuorum && !attained) {
            log.info((Object)"There is no longer a quorum. Any HA deployments will be undeployed until a quorum is re-attained");
            this.attainedQuorum = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToHA(String deploymentID, String moduleName, JsonObject conf, int instances) {
        JsonObject moduleConf = new JsonObject().putString("dep_id", deploymentID);
        moduleConf.putString("module_name", moduleName);
        if (conf != null) {
            moduleConf.putObject("conf", conf);
        }
        moduleConf.putNumber("instances", (Number)instances);
        JsonArray jsonArray = this.haMods;
        synchronized (jsonArray) {
            this.haMods.addObject(moduleConf);
        }
        this.clusterMap.put(this.nodeID, this.haInfo.encode());
    }

    private void addToHADeployList(final String moduleName, final JsonObject config, final int instances, final Handler<AsyncResult<String>> doneHandler) {
        this.toDeployOnQuorum.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DefaultContext ctx = HAManager.this.vertx.getContext();
                try {
                    HAManager.this.vertx.setContext(null);
                    HAManager.this.deployModule(moduleName, config, instances, (Handler<AsyncResult<String>>)doneHandler);
                }
                finally {
                    HAManager.this.vertx.setContext(ctx);
                }
            }
        });
    }

    private void checkHADeployments() {
        try {
            if (this.attainedQuorum) {
                this.deployHADeployments();
            } else {
                this.undeployHADeployments();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed when checking HA deployments", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployHADeployments() {
        for (final Map.Entry<String, Deployment> entry : this.platformManager.deployments().entrySet()) {
            if (!entry.getValue().ha) continue;
            DefaultContext ctx = this.vertx.getContext();
            try {
                this.vertx.setContext(null);
                this.platformManager.undeploy(entry.getKey(), (Handler<AsyncResult<Void>>)new AsyncResultHandler<Void>(){

                    public void handle(AsyncResult<Void> result) {
                        if (result.succeeded()) {
                            Deployment dep = (Deployment)entry.getValue();
                            log.info((Object)("Successfully undeployed HA deployment " + dep.modID + " as there is no quorum"));
                            HAManager.this.addToHADeployList(dep.modID.toString(), dep.config, dep.instances, (Handler<AsyncResult<String>>)((Handler)new AsyncResultHandler<String>(){

                                public void handle(AsyncResult<String> result) {
                                    if (result.succeeded()) {
                                        log.info((Object)("Successfully redeployed module " + ((Deployment)entry.getValue()).modID + " after quorum was re-attained"));
                                    } else {
                                        log.error((Object)("Failed to redeploy module " + ((Deployment)entry.getValue()).modID + " after quorum was re-attained"), result.cause());
                                    }
                                }
                            }));
                        } else {
                            log.error((Object)"Failed to undeploy deployment on lost quorum", result.cause());
                        }
                    }
                });
            }
            finally {
                this.vertx.setContext(ctx);
            }
        }
    }

    private void deployHADeployments() {
        int size = this.toDeployOnQuorum.size();
        if (size != 0) {
            Runnable task;
            log.info((Object)("There are " + size + " HA deployments waiting on a quorum. These will now be deployed"));
            while ((task = this.toDeployOnQuorum.poll()) != null) {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    log.error((Object)"Failed to run redeployment task", t);
                }
            }
        }
    }

    private void checkFailover(String failedNodeID, JsonObject theHAInfo) {
        block6: {
            try {
                JsonArray deployments = theHAInfo.getArray("mods");
                String group = theHAInfo.getString("group");
                String chosen = this.chooseHashedNode(group, failedNodeID.hashCode());
                if (chosen != null && chosen.equals(this.nodeID)) {
                    log.info((Object)("Node " + failedNodeID + " has failed. This node will deploy " + deployments.size() + " deployments from that node."));
                    if (deployments != null) {
                        for (Object obj : deployments) {
                            JsonObject app = (JsonObject)obj;
                            this.processFailover(app);
                        }
                    }
                    this.clusterMap.remove(failedNodeID);
                    if (this.failoverCompleteHandler != null) {
                        this.failoverCompleteHandler.handle((Object)true);
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)"Failed to handle failover", t);
                if (this.failoverCompleteHandler == null) break block6;
                this.failoverCompleteHandler.handle((Object)false);
            }
        }
    }

    private void processFailover(JsonObject failedModule) {
        if (this.failDuringFailover) {
            throw new VertxException("Oops!");
        }
        final String moduleName = failedModule.getString("module_name");
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference err = new AtomicReference();
        DefaultContext ctx = this.vertx.getContext();
        this.vertx.setContext(null);
        this.platformManager.deployModule(moduleName, failedModule.getObject("conf"), failedModule.getInteger("instances"), true, new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> result) {
                if (result.succeeded()) {
                    log.info((Object)("Successfully redeployed module " + moduleName + " after failover"));
                } else {
                    log.error((Object)"Failed to redeploy module after failover", result.cause());
                    err.set(result.cause());
                }
                latch.countDown();
                Throwable t = (Throwable)err.get();
                if (t != null) {
                    throw new VertxException(t);
                }
            }
        });
        this.vertx.setContext(ctx);
        try {
            if (!latch.await(120L, TimeUnit.SECONDS)) {
                throw new VertxException("Timed out waiting for redeploy on failover");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private String chooseHashedNode(String group, int hashCode) {
        List nodes = this.clusterManager.getNodes();
        ArrayList<String> matchingMembers = new ArrayList<String>();
        for (String node : nodes) {
            JsonObject clusterInfo;
            String memberGroup;
            String sclusterInfo = this.clusterMap.get(node);
            if (sclusterInfo == null || !group.equals(memberGroup = (clusterInfo = new JsonObject(sclusterInfo)).getString("group"))) continue;
            matchingMembers.add(node);
        }
        if (!matchingMembers.isEmpty()) {
            long absHash = (long)hashCode + Integer.MAX_VALUE;
            long lpos = absHash % (long)matchingMembers.size();
            return (String)matchingMembers.get((int)lpos);
        }
        return null;
    }
}

