import { LanguagePlugin, LanguageServiceEnvironment, ProviderResult, UriMap } from '@volar/language-service';
import type * as ts from 'typescript';
import { URI } from 'vscode-uri';
import type { LanguageServerProject } from '../types';
import { ProjectExposeContext } from './typescriptProjectLs';
export declare function createTypeScriptProject(ts: typeof import('typescript'), tsLocalized: ts.MapLike<string> | undefined, getLanguagePlugins: (serviceEnv: LanguageServiceEnvironment, projectContext: ProjectExposeContext) => ProviderResult<LanguagePlugin<URI>[]>): LanguageServerProject;
export declare function createUriConverter(): {
    asFileName: (parsed: URI) => string;
    asUri: (fileName: string) => URI;
};
export declare function sortTSConfigs(file: string, a: string, b: string): number;
export declare function isFileInDir(fileName: string, dir: string): boolean;
export declare function getWorkspaceFolder(uri: URI, workspaceFolders: UriMap<boolean>): URI;
