"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSimpleProject = createSimpleProject;
exports.createLanguageServiceEnvironment = createLanguageServiceEnvironment;
const language_service_1 = require("@volar/language-service");
function createSimpleProject(languagePlugins) {
    let server;
    let languageService;
    return {
        setup(_server) {
            server = _server;
            const language = (0, language_service_1.createLanguage)([
                { getLanguageId: uri => server.documents.get(server.getSyncedDocumentKey(uri) ?? uri.toString())?.languageId },
                ...languagePlugins,
            ], (0, language_service_1.createUriMap)(false), uri => {
                const documentKey = server.getSyncedDocumentKey(uri) ?? uri.toString();
                const document = server.documents.get(documentKey);
                if (document) {
                    language.scripts.set(uri, document.getSnapshot(), document.languageId);
                }
                else {
                    language.scripts.delete(uri);
                }
            });
            languageService = (0, language_service_1.createLanguageService)(language, server.languageServicePlugins, createLanguageServiceEnvironment(server, [...server.workspaceFolders.keys()]));
        },
        getLanguageService() {
            return languageService;
        },
        getExistingLanguageServices() {
            return [languageService];
        },
        reload() {
            languageService.dispose();
            this.setup(server);
        },
    };
}
function createLanguageServiceEnvironment(server, workspaceFolders) {
    return {
        workspaceFolders,
        fs: server.fs,
        locale: server.initializeParams?.locale,
        clientCapabilities: server.initializeParams?.capabilities,
        getConfiguration: server.getConfiguration,
        onDidChangeConfiguration: server.onDidChangeConfiguration,
        onDidChangeWatchedFiles: server.onDidChangeWatchedFiles,
    };
}
//# sourceMappingURL=simpleProject.js.map