/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.conversion.IProjectConversionEnabler;
import org.eclipse.m2e.core.project.conversion.IProjectConversionManager;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenWizardPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenArtifactComponent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class MavenPomWizardPage
extends AbstractMavenWizardPage {
    private Text projectText;
    private final ISelection selection;
    private MavenArtifactComponent pomComponent;
    private IProjectConversionEnabler projectConversionEnabler;

    public MavenPomWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.MavenPomWizardPage_title);
        this.setDescription(Messages.MavenPomWizardPage_desc);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)layout);
        ModifyListener modifyingListener = e -> this.dialogChanged();
        Label label = new Label(container, 0);
        label.setText(Messages.MavenPomWizardPage_lblProject);
        this.projectText = new Text(container, 2060);
        this.projectText.setEditable(false);
        this.projectText.setLayoutData((Object)new GridData(768));
        this.projectText.addModifyListener(modifyingListener);
        this.pomComponent = new MavenArtifactComponent(container, 0);
        this.pomComponent.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.pomComponent.setModifyingListener(modifyingListener);
        this.addFieldWithHistory("groupId", this.pomComponent.getGroupIdCombo());
        this.addFieldWithHistory("artifactId", this.pomComponent.getArtifactIdCombo());
        this.addFieldWithHistory("version", this.pomComponent.getVersionCombo());
        this.addFieldWithHistory("name", this.pomComponent.getNameCombo());
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    /*
     * WARNING - void declaration
     */
    private void initialize() {
        ISelection iSelection;
        String packagingToUse = "jar";
        List availablePackagingTypes = Arrays.asList(MavenArtifactComponent.PACKAGING_OPTIONS);
        if (this.selection != null && !this.selection.isEmpty() && (iSelection = this.selection) instanceof IStructuredSelection) {
            void ssel;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            Object object = obj;
            if (object instanceof IResource) {
                IContainer iContainer;
                IResource iResource = (IResource)object;
                IResource cfr_ignored_1 = (IResource)object;
                Object object2 = obj;
                if (object2 instanceof IContainer) {
                    void c;
                    IContainer iContainer2 = (IContainer)object2;
                    IContainer cfr_ignored_2 = (IContainer)object2;
                    iContainer = c;
                } else {
                    void resource;
                    iContainer = resource.getParent();
                }
                IContainer container = iContainer;
                this.projectText.setText(container.getFullPath().toString());
                this.pomComponent.setArtifactId(container.getName());
                this.pomComponent.setGroupId(container.getName());
                IContainer iContainer3 = container;
                if (iContainer3 instanceof IProject) {
                    void project;
                    IProject iProject = (IProject)iContainer3;
                    IProject cfr_ignored_3 = (IProject)iContainer3;
                    IProjectConversionManager pcm = MavenPlugin.getProjectConversionManager();
                    this.projectConversionEnabler = pcm.getConversionEnablerForProject((IProject)project);
                    if (this.projectConversionEnabler != null) {
                        availablePackagingTypes = this.projectConversionEnabler.getPackagingTypes((IProject)project);
                        packagingToUse = (String)availablePackagingTypes.get(0);
                    }
                }
            }
        }
        this.pomComponent.setVersion("0.0.1-SNAPSHOT");
        this.pomComponent.setPackagingTypes(availablePackagingTypes);
        this.pomComponent.setPackaging(packagingToUse);
        this.pomComponent.setFocus();
    }

    void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.MavenPomWizardPage_dialog_title);
        dialog.showClosedProjects(false);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.projectText.setText(((IPath)result[0]).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember(IPath.fromOSString((String)this.getProject()));
        if (this.getProject().length() == 0) {
            this.updateStatus(Messages.MavenPomWizardPage_error_folder);
            return;
        }
        if (container == null || (container.getType() & 2 | 4) == 0) {
            this.updateStatus(Messages.MavenPomWizardPage_error_folder2);
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(Messages.MavenPomWizardPage_error_folder_write);
            return;
        }
        String message = this.validateGroupIdInput(this.pomComponent.getGroupId());
        if (message != null) {
            this.updateStatus(message);
            return;
        }
        message = this.validateArtifactIdInput(this.pomComponent.getArtifactId());
        if (message != null) {
            this.updateStatus(message);
            return;
        }
        if (this.pomComponent.getVersion().length() == 0) {
            this.updateStatus(Messages.MavenPomWizardPage_error_version);
            return;
        }
        if (this.pomComponent.getPackaging().length() == 0) {
            this.updateStatus(Messages.MavenPomWizardPage_error_pack);
            return;
        }
        IResource iResource = container;
        if (iResource instanceof IProject) {
            void project;
            IStatus status;
            IProject iProject = (IProject)iResource;
            IProject cfr_ignored_0 = (IProject)iResource;
            if (this.projectConversionEnabler != null && (status = this.projectConversionEnabler.canBeConverted((IProject)project)).getSeverity() == 4) {
                this.updateStatus(status.getMessage());
                return;
            }
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getProject() {
        return this.projectText.getText();
    }

    public Model getModel() {
        return this.pomComponent.getModel();
    }
}

