/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ILifecycleMappingRequirement;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.IMavenDiscoveryProposal;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.LifecycleMappingDiscoveryRequest;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.MojoExecutionMappingConfiguration;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.m2e.core.ui.internal.editing.LifecycleMappingOperation;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.lifecyclemapping.ILifecycleMappingLabelProvider;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractCreateMavenProjectsOperation;
import org.eclipse.m2e.core.ui.internal.wizards.IMavenDiscoveryUI;
import org.eclipse.m2e.core.ui.internal.wizards.LifecycleMappingPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenDiscoveryProposalWizard
extends Wizard
implements IImportWizard {
    private static final Logger LOG = LoggerFactory.getLogger(MavenDiscoveryProposalWizard.class);
    private LifecycleMappingPage lifecycleMappingPage;
    private boolean initialized = false;
    private final LifecycleMappingDiscoveryRequest mappingDiscoveryRequest;
    private final Collection<IProject> projects;
    private IMavenDiscoveryUI pageFactory;

    public MavenDiscoveryProposalWizard(Collection<IProject> projects, LifecycleMappingDiscoveryRequest mappingDiscoveryRequest) {
        this.projects = projects;
        this.mappingDiscoveryRequest = mappingDiscoveryRequest;
        this.setNeedsProgressMonitor(false);
        this.setWindowTitle(Messages.MavenDiscoveryProposalWizard_title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.pageFactory = M2EUIPluginActivator.getDefault().getImportWizardPageFactory();
        this.initialized = true;
    }

    public void addPages() {
        if (!this.initialized) {
            this.init(null, null);
        }
        this.lifecycleMappingPage = new LifecycleMappingPage();
        this.addPage((IWizardPage)this.lifecycleMappingPage);
    }

    public boolean performFinish() {
        List<IMavenDiscoveryProposal> proposals = this.getMavenDiscoveryProposals();
        boolean doIgnore = !this.lifecycleMappingPage.getIgnore().isEmpty() || !this.lifecycleMappingPage.getIgnoreParent().isEmpty() || !this.lifecycleMappingPage.getIgnoreWorkspace().isEmpty();
        IMavenDiscoveryUI discovery = this.getPageFactory();
        if (discovery != null && !proposals.isEmpty()) {
            HashSet<String> projectsToConfigure = new HashSet<String>();
            for (IProject project : this.projects) {
                projectsToConfigure.add(project.getName());
            }
            doIgnore = discovery.implement(proposals, null, (IRunnableContext)this.getContainer(), projectsToConfigure);
        }
        if (doIgnore) {
            final IRunnableWithProgress ignoreJob = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement mojo;
                    ILifecycleMappingRequirement iLifecycleMappingRequirement;
                    ILifecycleMappingRequirement req;
                    LinkedList<IProject> changed = new LinkedList<IProject>();
                    for (ILifecycleMappingLabelProvider prov : MavenDiscoveryProposalWizard.this.lifecycleMappingPage.getIgnore()) {
                        req = prov.getKey();
                        iLifecycleMappingRequirement = req;
                        if (!(iLifecycleMappingRequirement instanceof MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)) continue;
                        MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement cfr_ignored_0 = (MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)iLifecycleMappingRequirement;
                        MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement cfr_ignored_1 = (MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)iLifecycleMappingRequirement;
                        changed.addAll(this.getProject(prov.getProjects()));
                        this.ignore(mojo.getExecution(), prov.getProjects());
                    }
                    for (ILifecycleMappingLabelProvider prov : MavenDiscoveryProposalWizard.this.lifecycleMappingPage.getIgnoreParent()) {
                        req = prov.getKey();
                        iLifecycleMappingRequirement = req;
                        if (!(iLifecycleMappingRequirement instanceof MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)) continue;
                        MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement cfr_ignored_2 = (MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)iLifecycleMappingRequirement;
                        MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement cfr_ignored_3 = (MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)iLifecycleMappingRequirement;
                        changed.addAll(this.getProject(prov.getProjects()));
                        this.ignoreAtDefinition(mojo.getExecution(), prov.getProjects());
                    }
                    for (ILifecycleMappingLabelProvider prov : MavenDiscoveryProposalWizard.this.lifecycleMappingPage.getIgnoreWorkspace()) {
                        req = prov.getKey();
                        iLifecycleMappingRequirement = req;
                        if (!(iLifecycleMappingRequirement instanceof MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)) continue;
                        MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement cfr_ignored_4 = (MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)iLifecycleMappingRequirement;
                        MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement cfr_ignored_5 = (MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)iLifecycleMappingRequirement;
                        changed.addAll(this.getProject(prov.getProjects()));
                        this.ignoreWorkspace(mojo.getExecution());
                    }
                    new UpdateMavenProjectJob(changed).schedule();
                }

                private Collection<IProject> getProject(Collection<MavenProject> projects) {
                    LinkedList<IProject> workspaceProjects = new LinkedList<IProject>();
                    for (MavenProject project : projects) {
                        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getMavenProject(project.getGroupId(), project.getArtifactId(), project.getVersion());
                        if (facade == null) continue;
                        workspaceProjects.add(facade.getProject());
                    }
                    return workspaceProjects;
                }

                private void ignore(MojoExecutionKey key, Collection<MavenProject> projects) {
                    String pluginGroupId = key.groupId();
                    String pluginArtifactId = key.artifactId();
                    String pluginVersion = key.version();
                    String[] goals = new String[]{key.goal()};
                    for (MavenProject project : projects) {
                        IFile pomFile = M2EUtils.getPomFile((MavenProject)project);
                        try {
                            PomEdits.performOnDOMDocument(new PomEdits.OperationTuple(pomFile, (PomEdits.Operation)new LifecycleMappingOperation(pluginGroupId, pluginArtifactId, pluginVersion, PluginExecutionAction.ignore, goals)));
                        }
                        catch (IOException ex) {
                            LOG.error(ex.getMessage(), (Throwable)ex);
                        }
                        catch (CoreException ex) {
                            LOG.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                }

                private void ignoreAtDefinition(MojoExecutionKey key, Collection<MavenProject> projects) {
                    this.ignore(key, M2EUtils.getDefiningProjects((MojoExecutionKey)key, projects));
                }

                private void ignoreWorkspace(MojoExecutionKey key) {
                    LifecycleMappingMetadataSource mapping = LifecycleMappingFactory.getWorkspaceMetadata((boolean)true);
                    LifecycleMappingFactory.addLifecyclePluginExecution((LifecycleMappingMetadataSource)mapping, (String)key.groupId(), (String)key.artifactId(), (String)key.version(), List.of(key.goal()), (PluginExecutionAction)PluginExecutionAction.ignore);
                    LifecycleMappingFactory.writeWorkspaceMetadata((LifecycleMappingMetadataSource)mapping);
                }
            };
            WorkspaceJob job = new WorkspaceJob("Apply Lifecycle Mapping Changes"){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    try {
                        ignoreJob.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        return AbstractCreateMavenProjectsOperation.toStatus(e);
                    }
                    catch (InterruptedException e) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
            job.schedule();
        }
        return true;
    }

    private IMavenDiscoveryUI getPageFactory() {
        return this.pageFactory;
    }

    public boolean canFinish() {
        return true;
    }

    private List<IMavenDiscoveryProposal> getMavenDiscoveryProposals() {
        if (this.lifecycleMappingPage == null) {
            return Collections.emptyList();
        }
        return this.lifecycleMappingPage.getSelectedDiscoveryProposals();
    }

    public LifecycleMappingDiscoveryRequest getLifecycleMappingDiscoveryRequest() {
        return this.mappingDiscoveryRequest;
    }
}

