/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import aQute.bnd.build.Workspace;
import aQute.bnd.memoize.Memoize;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.RepositoryPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bndtools.api.ILogger;
import org.bndtools.api.Logger;
import org.bndtools.api.PopulatedRepository;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class RepositoryUtils {
    private static final ILogger logger = Logger.getLogger(RepositoryUtils.class);
    private static final Memoize<ServiceTracker<RepositoryPlugin, RepositoryPlugin>> pluginTracker = Memoize.predicateSupplier(() -> {
        Optional<ServiceTracker> tracker = Optional.ofNullable(FrameworkUtil.getBundle(RepositoryUtils.class)).map(Bundle::getBundleContext).map(context -> new ServiceTracker(context, RepositoryPlugin.class, null));
        tracker.ifPresent(ServiceTracker::open);
        return tracker.orElse(null);
    }, Objects::nonNull);

    public static List<RepositoryPlugin> listRepositories(Workspace localWorkspace, boolean hideCache) {
        if (localWorkspace == null) {
            return Collections.emptyList();
        }
        try {
            return (List)localWorkspace.readLocked(() -> {
                List plugins = localWorkspace.getPlugins(RepositoryPlugin.class);
                plugins.addAll(RepositoryUtils.getAdditionalPlugins());
                ArrayList<RepositoryPlugin> repos = new ArrayList<RepositoryPlugin>(plugins.size() + 1);
                for (RepositoryPlugin plugin : plugins) {
                    if (plugin instanceof PopulatedRepository && ((PopulatedRepository)plugin).isEmpty() || hideCache && "bnd-cache".equals(plugin.getName())) continue;
                    repos.add(plugin);
                }
                for (RepositoryPlugin repo : repos) {
                    if (!(repo instanceof RegistryPlugin)) continue;
                    RegistryPlugin registry = (RegistryPlugin)repo;
                    registry.setRegistry((Registry)localWorkspace);
                }
                return repos;
            });
        }
        catch (Exception e) {
            logger.logError("Error loading repositories: " + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static Collection<RepositoryPlugin> getAdditionalPlugins() {
        return Optional.ofNullable((ServiceTracker)pluginTracker.get()).map(ServiceTracker::getTracked).map(Map::values).orElse(Collections.emptyList());
    }
}

