/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.team.ui.ContextChangeSet;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.team.ui.AbstractActiveChangeSetProvider;
import org.eclipse.mylyn.team.ui.AbstractContextChangeSetManager;
import org.eclipse.mylyn.team.ui.IContextChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.IChangeSetChangeListener;

public class ContextActiveChangeSetManager
extends AbstractContextChangeSetManager {
    private final List<ActiveChangeSetManager> changeSetManagers = new ArrayList<ActiveChangeSetManager>();
    private final List<IContextChangeSet> activeChangeSets = new ArrayList<IContextChangeSet>();
    private final Map<ActiveChangeSetManager, ChangeSetChangeListener> listenerByManager = new HashMap<ActiveChangeSetManager, ChangeSetChangeListener>();

    public ContextActiveChangeSetManager() {
        Collection<AbstractActiveChangeSetProvider> providerList = FocusedTeamUiPlugin.getDefault().getActiveChangeSetProviders();
        for (AbstractActiveChangeSetProvider provider : providerList) {
            ActiveChangeSetManager changeSetManager = provider.getActiveChangeSetManager();
            if (changeSetManager == null) continue;
            this.changeSetManagers.add(changeSetManager);
        }
    }

    @Override
    protected void updateChangeSetLabel(ITask task) {
        for (ActiveChangeSetManager collector : this.changeSetManagers) {
            ChangeSet[] sets;
            ChangeSet[] changeSetArray = sets = collector.getSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                IContextChangeSet contextChangeSet;
                ChangeSet set = changeSetArray[n2];
                if (set instanceof IContextChangeSet && (contextChangeSet = (IContextChangeSet)set).getTask().equals(task)) {
                    contextChangeSet.updateLabel();
                }
                ++n2;
            }
        }
    }

    @Override
    public void enable() {
        super.enable();
        for (ActiveChangeSetManager collector : this.changeSetManagers) {
            ChangeSetChangeListener listener = this.listenerByManager.get(collector);
            if (listener != null) continue;
            listener = new ChangeSetChangeListener(collector);
            this.listenerByManager.put(collector, listener);
            collector.addListener((IChangeSetChangeListener)listener);
        }
    }

    @Override
    public void disable() {
        super.disable();
        for (ActiveChangeSetManager collector : this.changeSetManagers) {
            ChangeSetChangeListener listener = this.listenerByManager.get(collector);
            if (listener == null) continue;
            collector.removeListener((IChangeSetChangeListener)listener);
            this.listenerByManager.remove(collector);
        }
    }

    @Override
    protected void initContextChangeSets() {
        for (ActiveChangeSetManager manager : this.changeSetManagers) {
            ChangeSet[] sets;
            ChangeSet[] changeSetArray = sets = manager.getSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeSet restoredSet = changeSetArray[n2];
                if (!(restoredSet instanceof IContextChangeSet)) {
                    String encodedTitle = restoredSet.getName();
                    String taskHandle = ContextChangeSet.getHandleFromPersistedTitle(encodedTitle);
                    ITask task = TasksUi.getRepositoryModel().getTask(taskHandle);
                    if (task != null) {
                        try {
                            IContextChangeSet contextChangeSet = this.getOrCreateSet(manager, task);
                            if (contextChangeSet instanceof ActiveChangeSet) {
                                contextChangeSet.restoreResources(restoredSet.getResources());
                                manager.remove(restoredSet);
                                manager.add((ChangeSet)((ActiveChangeSet)contextChangeSet));
                            }
                        }
                        catch (Exception e) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.team.ui", "Could not restore change set", (Throwable)e));
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public void clearActiveChangeSets() {
        this.activeChangeSets.clear();
    }

    public IResource[] getResources(ITask task) {
        for (ActiveChangeSetManager collector : this.changeSetManagers) {
            ChangeSet[] sets;
            ChangeSet[] changeSetArray = sets = collector.getSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                IContextChangeSet contextChangeSet;
                ChangeSet set = changeSetArray[n2];
                if (set instanceof IContextChangeSet && (contextChangeSet = (IContextChangeSet)set).getTask().equals(task) && contextChangeSet instanceof ActiveChangeSet) {
                    return ((ActiveChangeSet)contextChangeSet).getResources();
                }
                ++n2;
            }
        }
        return null;
    }

    public void contextActivated(IInteractionContext context) {
        try {
            ITask task = this.getTask(context);
            if (task != null) {
                for (ActiveChangeSetManager manager : this.changeSetManagers) {
                    IContextChangeSet contextChangeSet = this.getOrCreateSet(manager, task);
                    if (!(contextChangeSet instanceof ActiveChangeSet)) continue;
                    ActiveChangeSet activeChangeSet = (ActiveChangeSet)contextChangeSet;
                    this.activeChangeSets.add(contextChangeSet);
                    manager.makeDefault(activeChangeSet);
                }
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.team.ui", "Could not update change set", (Throwable)e));
        }
    }

    private IContextChangeSet getOrCreateSet(ActiveChangeSetManager manager, ITask task) {
        ChangeSet[] sets;
        ChangeSet[] changeSetArray = sets = manager.getSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet set = changeSetArray[n2];
            if (set instanceof IContextChangeSet && task.equals(((IContextChangeSet)set).getTask())) {
                return (IContextChangeSet)set;
            }
            ++n2;
        }
        AbstractActiveChangeSetProvider provider = FocusedTeamUiPlugin.getDefault().getActiveChangeSetProvider(manager);
        return provider.createChangeSet(task);
    }

    public void contextDeactivated(IInteractionContext context) {
        for (ActiveChangeSetManager collector : this.changeSetManagers) {
            ChangeSet[] sets;
            ChangeSet[] changeSetArray = sets = collector.getSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                IResource[] resources;
                ChangeSet set = changeSetArray[n2];
                if (set instanceof ActiveChangeSet && ((resources = set.getResources()) == null || resources.length == 0)) {
                    collector.remove(set);
                }
                ++n2;
            }
            AbstractActiveChangeSetProvider changeSetProvider = FocusedTeamUiPlugin.getDefault().getActiveChangeSetProvider(collector);
            changeSetProvider.activateDefaultChangeSet();
        }
        this.activeChangeSets.clear();
    }

    public void interestChanged(List<IInteractionElement> elements) {
    }

    public List<IContextChangeSet> getActiveChangeSets() {
        return new ArrayList<IContextChangeSet>(this.activeChangeSets);
    }

    private ITask getTask(IInteractionContext context) {
        return TasksUi.getTaskActivityManager().getActiveTask();
    }

    private class ChangeSetChangeListener
    implements IChangeSetChangeListener {
        private final ActiveChangeSetManager manager;

        public ChangeSetChangeListener(ActiveChangeSetManager manager) {
            this.manager = manager;
        }

        public void setRemoved(ChangeSet set) {
            IContextChangeSet contextChangeSet;
            if (set instanceof IContextChangeSet && (contextChangeSet = (IContextChangeSet)set).getTask() != null && contextChangeSet.getTask().isActive()) {
                this.manager.add((ChangeSet)((ActiveChangeSet)contextChangeSet));
            }
        }

        public void setAdded(ChangeSet set) {
        }

        public void defaultSetChanged(ChangeSet previousDefault, ChangeSet set) {
        }

        public void nameChanged(ChangeSet set) {
        }

        public void resourcesChanged(ChangeSet set, IPath[] paths) {
        }
    }
}

