/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.model;

import java.util.function.Supplier;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.themes.ColorUtil;

public enum SystemDefaultColors implements Supplier<RGB>
{
    FOREGROUND("Foreground", "COLOR_LIST_FOREGROUND", new RGB(0, 0, 0)),
    BACKGROUND("Background", "COLOR_LIST_BACKGROUND", new RGB(255, 255, 255)),
    SELECTION_FOREGROUND("SelectionForeground", "COLOR_LIST_SELECTION_TEXT", new RGB(255, 255, 255)),
    SELECTION_BACKGROUND("SelectionBackground", "COLOR_LIST_SELECTION", new RGB(74, 144, 9));

    private static final String EDITOR_SCOPE = "org.eclipse.ui.editors";
    private static final String PREF_PREFIX = "AbstractTextEditor.Color.";
    private static final String PREF_SYSTEM_DEFAULT_SUFFIX = ".SystemDefault";
    private String swtColor;
    private String editorColor;
    private RGB fallbackColor;

    private SystemDefaultColors(String editorColor, String swtColor, RGB rgb) {
        this.editorColor = editorColor;
        this.swtColor = swtColor;
        this.fallbackColor = rgb;
    }

    @Override
    public RGB get() {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, EDITOR_SCOPE);
        RGB rgb = null;
        String pref = PREF_PREFIX + this.editorColor;
        String prefSystemDefault = pref + PREF_SYSTEM_DEFAULT_SUFFIX;
        if (Platform.getPreferencesService() != null && !store.getBoolean(prefSystemDefault) && store.contains(pref)) {
            rgb = store.isDefault(pref) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)pref) : PreferenceConverter.getColor((IPreferenceStore)store, (String)pref);
        }
        if (rgb == null) {
            rgb = ColorUtil.getColorValue((String)this.swtColor);
        }
        if (rgb == null) {
            rgb = this.fallbackColor;
        }
        return rgb;
    }
}

