/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.wizards.groups;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.workspace.ui.internal.Activator;
import org.eclipse.sphinx.emf.workspace.ui.internal.messages.Messages;
import org.eclipse.sphinx.platform.preferences.IProjectWorkspacePreference;
import org.eclipse.sphinx.platform.ui.fields.ComboField;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.fields.IFieldListener;
import org.eclipse.sphinx.platform.ui.fields.SelectionButtonField;
import org.eclipse.sphinx.platform.ui.groups.AbstractGroup;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class BasicMetaModelVersionGroup<T extends IMetaModelDescriptor>
extends AbstractGroup {
    protected static final String LAST_SELECTED_METAMODEL_VERSION_OPTION = String.valueOf(Activator.getPlugin().getSymbolicName()) + "last.selected.metamodel.version";
    protected static final String LAST_SELECTED_METAMODEL_VERSION_KEY = String.valueOf(Activator.getPlugin().getSymbolicName()) + "last.selected.project.metamodel.version";
    protected static final int WORKSPACE_DEFAULT_METAMODEL_VERSION = 0;
    protected static final int ALTERNATE_METAMODEL_VERSION = 1;
    protected T baseMetaModelDescriptor;
    protected IProjectWorkspacePreference<T> metaModelVersionPreference;
    protected String metaModelVersionPreferencePageId;
    protected SelectionButtonField workspaceDefaultMetaModelVersionButton;
    protected SelectionButtonField alternateMetaModelVersionButton;
    protected ComboField metaModelVersionCombo;
    protected Link configureWorkspaceSettingsLink;
    protected List<T> supportedMetaModelVersions = new ArrayList<T>();
    private String metaModelVersionLabel = null;
    private IFieldListener fieldListener = new IFieldListener(){

        public void dialogFieldChanged(IField field) {
            BasicMetaModelVersionGroup.this.updateEnableState();
            if (field == BasicMetaModelVersionGroup.this.workspaceDefaultMetaModelVersionButton) {
                Activator.getPlugin().getDialogSettings().put(LAST_SELECTED_METAMODEL_VERSION_OPTION, 0);
            } else if (field == BasicMetaModelVersionGroup.this.alternateMetaModelVersionButton) {
                Activator.getPlugin().getDialogSettings().put(LAST_SELECTED_METAMODEL_VERSION_OPTION, 1);
            } else if (field == BasicMetaModelVersionGroup.this.metaModelVersionCombo && BasicMetaModelVersionGroup.this.alternateMetaModelVersionButton.isSelected()) {
                BasicMetaModelVersionGroup.this.storeSelectionState((ComboField)field);
            }
        }
    };
    private SelectionListener selectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent event) {
            PreferencesUtil.createPreferenceDialogOn(null, (String)BasicMetaModelVersionGroup.this.metaModelVersionPreferencePageId, (String[])new String[]{BasicMetaModelVersionGroup.this.metaModelVersionPreferencePageId}, null).open();
        }

        public void widgetSelected(SelectionEvent event) {
            this.widgetDefaultSelected(event);
        }
    };

    public BasicMetaModelVersionGroup(String groupName, T baseMetaModelDescriptor, IProjectWorkspacePreference<T> metaModelVersionPreference, String metaModelVersionPreferencePageId) {
        super(groupName);
        Assert.isNotNull(baseMetaModelDescriptor);
        Assert.isLegal((baseMetaModelDescriptor != MetaModelDescriptorRegistry.ANY_MM ? 1 : 0) != 0);
        Assert.isLegal((baseMetaModelDescriptor != MetaModelDescriptorRegistry.NO_MM ? 1 : 0) != 0);
        Assert.isNotNull(metaModelVersionPreference);
        this.baseMetaModelDescriptor = baseMetaModelDescriptor;
        this.metaModelVersionPreference = metaModelVersionPreference;
        this.metaModelVersionPreferencePageId = metaModelVersionPreferencePageId;
    }

    protected void doCreateContent(Composite group, int numColumns) {
        group.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(3, false);
        group.setLayout((Layout)gridLayout);
        ((Group)group).setText(this.getMetaModelVersionGroupLabel());
        this.workspaceDefaultMetaModelVersionButton = new SelectionButtonField(16);
        this.workspaceDefaultMetaModelVersionButton.setLabelText(NLS.bind((String)Messages.button_workspaceDefaultMetaModelVersion_label, (Object)this.getWorkspaceDefaultMetaModelVersionLabelPrefix(), (Object)((IMetaModelDescriptor)this.metaModelVersionPreference.getFromWorkspace()).getName()));
        this.workspaceDefaultMetaModelVersionButton.fillIntoGrid(group, 2);
        this.workspaceDefaultMetaModelVersionButton.addFieldListener(this.fieldListener);
        if (this.metaModelVersionPreferencePageId != null) {
            this.configureWorkspaceSettingsLink = new Link(group, 0);
            this.configureWorkspaceSettingsLink.setFont(group.getFont());
            this.configureWorkspaceSettingsLink.setText(MessageFormat.format("<a>{0}</a>", Messages.link_configureWorkspaceSettings_label));
            this.configureWorkspaceSettingsLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            this.configureWorkspaceSettingsLink.addSelectionListener(this.selectionListener);
        }
        this.alternateMetaModelVersionButton = new SelectionButtonField(16);
        this.alternateMetaModelVersionButton.setLabelText(this.getAlternateMetaModelVersionLabel());
        this.alternateMetaModelVersionButton.fillIntoGrid(group, 1);
        this.alternateMetaModelVersionButton.addFieldListener(this.fieldListener);
        this.metaModelVersionCombo = new ComboField(8);
        this.metaModelVersionCombo.fillIntoGrid(group, 2);
        this.metaModelVersionCombo.addFieldListener(this.fieldListener);
        this.fillMetaModelVersionCombo(this.baseMetaModelDescriptor);
        Combo comboControl = (Combo)this.metaModelVersionCombo.getComboControl();
        comboControl.setLayoutData((Object)new GridData(4, 2, true, false));
        comboControl.setVisibleItemCount(10);
        switch (this.getLastSelectedMetaModelVersionOption()) {
            case 0: {
                this.workspaceDefaultMetaModelVersionButton.setSelection(true);
                break;
            }
            case 1: {
                this.alternateMetaModelVersionButton.setSelection(true);
                break;
            }
            default: {
                this.workspaceDefaultMetaModelVersionButton.setSelection(true);
            }
        }
        this.updateEnableState();
    }

    protected String getMetaModelVersionLabel() {
        if (this.metaModelVersionLabel == null) {
            this.metaModelVersionLabel = Messages.default_metaModelVersionLabel;
        }
        return this.metaModelVersionLabel;
    }

    public void setMetaModelVersionLabel(String metaModelVersionLabel) {
        this.metaModelVersionLabel = metaModelVersionLabel;
    }

    protected String getMetaModelVersionGroupLabel() {
        return NLS.bind((String)Messages.group_metaModelVersion_label, (Object)this.baseMetaModelDescriptor.getName(), (Object)this.getMetaModelVersionLabel());
    }

    protected String getAlternateMetaModelVersionLabel() {
        return NLS.bind((String)Messages.button_alternateMetaModelVersion_label, (Object)this.getMetaModelVersionLabel());
    }

    protected String getWorkspaceDefaultMetaModelVersionLabelPrefix() {
        return NLS.bind((String)Messages.button_workspaceDefaultMetaModelVersion_labelPrefix, (Object)this.getMetaModelVersionLabel());
    }

    protected void fillMetaModelVersionCombo(T metaModelDescriptor) {
        String selectedMetaModelVersionId;
        IMetaModelDescriptor descriptor;
        this.supportedMetaModelVersions = MetaModelDescriptorRegistry.INSTANCE.getDescriptors(metaModelDescriptor, true);
        if (!this.supportedMetaModelVersions.isEmpty()) {
            String[] items = new String[this.supportedMetaModelVersions.size()];
            int index = 0;
            while (index < this.supportedMetaModelVersions.size()) {
                IMetaModelDescriptor descriptor2 = (IMetaModelDescriptor)this.supportedMetaModelVersions.get(index);
                items[index] = NLS.bind((String)Messages.combo_metaModelVersion_item, (Object)descriptor2.getName(), (Object)descriptor2.getNamespace());
                ++index;
            }
            this.metaModelVersionCombo.setItems(items);
        }
        if (this.supportedMetaModelVersions.contains(descriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(selectedMetaModelVersionId = this.getLastSelectedMetaModelVersionIdentifier()))) {
            this.metaModelVersionCombo.selectItem(this.supportedMetaModelVersions.indexOf(descriptor));
        } else {
            IMetaModelDescriptor workspaceMetaModelVersion = (IMetaModelDescriptor)this.metaModelVersionPreference.getFromWorkspace();
            if (this.supportedMetaModelVersions.contains(workspaceMetaModelVersion)) {
                this.metaModelVersionCombo.selectItem(this.supportedMetaModelVersions.indexOf(workspaceMetaModelVersion));
            }
        }
    }

    protected void updateEnableState() {
        this.metaModelVersionCombo.setEnabled(this.alternateMetaModelVersionButton.isSelected());
        this.configureWorkspaceSettingsLink.setEnabled(this.workspaceDefaultMetaModelVersionButton.isSelected());
    }

    public T getMetaModelVersionDescriptor() {
        int index;
        if (this.workspaceDefaultMetaModelVersionButton.isSelected()) {
            return (T)((IMetaModelDescriptor)this.metaModelVersionPreference.getFromWorkspace());
        }
        if (this.alternateMetaModelVersionButton.isSelected() && (index = this.metaModelVersionCombo.getSelectionIndex()) > -1) {
            IMetaModelDescriptor descriptor = (IMetaModelDescriptor)this.supportedMetaModelVersions.get(index);
            return (T)descriptor;
        }
        return null;
    }

    protected int getLastSelectedMetaModelVersionOption() {
        IDialogSettings dialogSettings = Activator.getPlugin().getDialogSettings();
        if (dialogSettings.get(LAST_SELECTED_METAMODEL_VERSION_OPTION) == null) {
            return 0;
        }
        return dialogSettings.getInt(LAST_SELECTED_METAMODEL_VERSION_OPTION);
    }

    protected String getLastSelectedMetaModelVersionIdentifier() {
        IDialogSettings dialogSettings = Activator.getPlugin().getDialogSettings();
        return dialogSettings.get(LAST_SELECTED_METAMODEL_VERSION_KEY);
    }

    protected void storeSelectionState(ComboField comboField) {
        IMetaModelDescriptor descriptor;
        int index = comboField.getSelectionIndex();
        if (index > -1 && (descriptor = (IMetaModelDescriptor)this.supportedMetaModelVersions.get(index)) != null) {
            String item = descriptor.getIdentifier();
            Activator.getPlugin().getDialogSettings().put(LAST_SELECTED_METAMODEL_VERSION_KEY, item);
        }
    }
}

