/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.team.subversive.ui.operations;

import java.io.File;
import java.util.Calendar;
import java.util.Collections;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.compare.ui.editor.ModelElementCompareEditorInput;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.workspace.domain.WorkspaceEditingDomainManager;
import org.eclipse.sphinx.emf.workspace.domain.factory.IExtendedTransactionalEditingDomainFactory;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.local.GetLocalFileContentOperation;
import org.eclipse.team.svn.core.operation.remote.GetFileContentOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.operation.CompareResourcesInternalOperation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class ExtendedCompareResourcesInternalOperation
extends CompareResourcesInternalOperation {
    protected TransactionalEditingDomain editingDomain;

    public ExtendedCompareResourcesInternalOperation(ILocalResource local, IRepositoryResource remote) {
        super(local, remote, false, false);
    }

    public ExtendedCompareResourcesInternalOperation(ILocalResource local, IRepositoryResource remote, boolean forceReuse) {
        super(local, remote, forceReuse, false);
    }

    public ExtendedCompareResourcesInternalOperation(ILocalResource local, IRepositoryResource remote, boolean forceReuse, boolean showInDialog) {
        super(local, remote, forceReuse, showInDialog);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File tempFile;
        GetLocalFileContentOperation op;
        int revisionKind;
        EObject leftObject = null;
        EObject rightObject = null;
        EObject ancestorObject = null;
        IResource localResource = this.local.getResource();
        leftObject = EcorePlatformUtil.loadModelRoot((IFile)((IFile)localResource));
        this.editingDomain = this.getEditingDomain(MetaModelDescriptorRegistry.INSTANCE.getDescriptor(leftObject));
        if (this.remote.getSelectedRevision() != SVNRevision.INVALID_REVISION && this.remote instanceof IRepositoryFile) {
            revisionKind = this.remote.getSelectedRevision().getKind();
            op = revisionKind == 6 || revisionKind == 5 ? new GetLocalFileContentOperation(this.local.getResource(), revisionKind) : new GetFileContentOperation(this.remote);
            op.run(monitor);
            if (op.getExecutionState() == 1) {
                this.reportStatus(op.getStatus());
                return;
            }
            if (monitor.isCanceled()) {
                return;
            }
            tempFile = new File(op.getTemporaryPath());
            rightObject = EcoreResourceUtil.loadModelRoot((ResourceSet)this.editingDomain.getResourceSet(), (File)tempFile, null);
            Assert.isNotNull((Object)rightObject);
            ((AdapterFactoryEditingDomain)this.editingDomain).getResourceToReadOnlyMap().put(rightObject.eResource(), true);
        }
        if (this.ancestor.getSelectedRevision() != SVNRevision.INVALID_REVISION && this.ancestor instanceof IRepositoryFile) {
            revisionKind = this.ancestor.getSelectedRevision().getKind();
            op = revisionKind == 6 || revisionKind == 5 ? new GetLocalFileContentOperation(this.local.getResource(), revisionKind) : new GetFileContentOperation(this.ancestor);
            op.run(monitor);
            monitor.done();
            if (op.getExecutionState() == 1) {
                this.reportStatus(op.getStatus());
                return;
            }
            if (monitor.isCanceled()) {
                return;
            }
            tempFile = new File(op.getTemporaryPath());
            ancestorObject = EcoreResourceUtil.loadModelRoot((ResourceSet)this.editingDomain.getResourceSet(), (File)tempFile, null);
            Assert.isNotNull((Object)ancestorObject);
            ((AdapterFactoryEditingDomain)this.editingDomain).getResourceToReadOnlyMap().put(ancestorObject.eResource(), true);
        }
        MatchModel matchModel = MatchService.doContentMatch((EObject)leftObject, rightObject, ancestorObject, null);
        DiffModel diffModel = DiffService.doDiff((MatchModel)matchModel);
        ComparisonSnapshot comparisonSnapshot = this.createComparisonSnapshot(matchModel, diffModel);
        CompareEditorInput input = this.getCompareEditorInput(comparisonSnapshot);
        this.openCompareEditor(input, ExtendedPlatformUI.getActivePage(), null);
    }

    protected CompareEditorInput getCompareEditorInput(ComparisonSnapshot comparisonSnapshot) {
        IPreferenceStore ps;
        ModelElementCompareEditorInput input = new ModelElementCompareEditorInput(comparisonSnapshot);
        CompareConfiguration configuration = input.getCompareConfiguration();
        if (configuration != null && (ps = configuration.getPreferenceStore()) != null) {
            configuration.setProperty("USE_OUTLINE_VIEW", (Object)ps.getBoolean("org.eclipse.compare.UseOutlineView"));
            configuration.setRightEditable(false);
        }
        input.setEditingDomain(this.editingDomain);
        return input;
    }

    protected ComparisonSnapshot createComparisonSnapshot(MatchModel matchModel, DiffModel diffModel) {
        ComparisonResourceSnapshot snapshot = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
        snapshot.setDate(Calendar.getInstance().getTime());
        snapshot.setDiff(diffModel);
        snapshot.setMatch(matchModel);
        return snapshot;
    }

    protected void openCompareEditor(final CompareEditorInput input, final IWorkbenchPage page, final IReusableEditor editor) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (editor != null && !editor.getSite().getShell().isDisposed()) {
                    editor.setInput((IEditorInput)input);
                    return;
                }
                if (page != null) {
                    try {
                        page.openEditor((IEditorInput)input, ExtendedCompareResourcesInternalOperation.this.getCompareEditorId(input));
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                } else {
                    MessageDialog.openError((Shell)ExtendedPlatformUI.getActiveShell(), (String)"Open Editor Error", (String)"Active page is null");
                }
            }
        };
        Display display = ExtendedPlatformUI.getDisplay();
        if (display != null) {
            display.syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    protected String getCompareEditorId(CompareEditorInput input) {
        return "org.eclipse.sphinx.emf.compare.ui.editors.modelCompareEditor";
    }

    protected TransactionalEditingDomain getEditingDomain(IMetaModelDescriptor mmDescriptor) {
        Assert.isNotNull((Object)mmDescriptor);
        if (this.editingDomain != null) {
            return this.editingDomain;
        }
        IExtendedTransactionalEditingDomainFactory factory = WorkspaceEditingDomainManager.INSTANCE.getEditingDomainFactory(mmDescriptor);
        if (factory == null) {
            throw new NullPointerException(NLS.bind((String)Messages.error_notFound_editingDomainFactory, (Object)mmDescriptor.getName()));
        }
        this.editingDomain = factory.createEditingDomain(Collections.singletonList(mmDescriptor));
        return this.editingDomain;
    }
}

