/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.ui.editor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.sphinx.emf.compare.ui.editor.ModelElementCompareEditorInput;
import org.eclipse.sphinx.emf.compare.ui.internal.Activator;
import org.eclipse.sphinx.emf.compare.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.messages.EMFMessages;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.ui.saving.BasicModelSaveablesProvider;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SaveablesLifecycleEvent;

public class ModelCompareEditor
extends CompareEditor {
    public static String ID = "org.eclipse.sphinx.emf.compare.ui.editors.modelCompareEditor";
    protected IUndoContext undoContext = new ObjectUndoContext((Object)this, ID);
    private IOperationHistoryListener affectedObjectsListener;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        HashSet<TransactionalEditingDomain> editingDomains = new HashSet<TransactionalEditingDomain>();
        TransactionalEditingDomain[] transactionalEditingDomainArray = this.getEditingDomains();
        int n = transactionalEditingDomainArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransactionalEditingDomain editingDomain = transactionalEditingDomainArray[n2];
            if (editingDomain != null) {
                editingDomains.add(editingDomain);
            }
            ++n2;
        }
        if (editingDomains.isEmpty()) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)new RuntimeException(EMFMessages.error_notFound_editingDomain));
        }
        for (TransactionalEditingDomain editingDomain : editingDomains) {
            this.addTransactionalEditingDomainListeners(editingDomain);
        }
    }

    public void dispose() {
        TransactionalEditingDomain[] transactionalEditingDomainArray = this.getEditingDomains();
        int n = transactionalEditingDomainArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransactionalEditingDomain editingDomain = transactionalEditingDomainArray[n2];
            if (editingDomain != null) {
                this.removeTransactionalEditingDomainListeners(editingDomain);
            }
            ++n2;
        }
        transactionalEditingDomainArray = this.getOperationHistories();
        n = transactionalEditingDomainArray.length;
        n2 = 0;
        while (n2 < n) {
            TransactionalEditingDomain operationHistory = transactionalEditingDomainArray[n2];
            if (operationHistory != null) {
                operationHistory.dispose(this.getUndoContext(), true, true, true);
            }
            ++n2;
        }
        super.dispose();
    }

    protected void addTransactionalEditingDomainListeners(TransactionalEditingDomain editingDomain) {
        if (editingDomain != null) {
            this.affectedObjectsListener = this.createAffectedObjectsListener();
            Assert.isNotNull((Object)this.affectedObjectsListener);
            ((IWorkspaceCommandStack)editingDomain.getCommandStack()).getOperationHistory().addOperationHistoryListener(this.affectedObjectsListener);
        }
    }

    protected void removeTransactionalEditingDomainListeners(TransactionalEditingDomain editingDomain) {
        if (editingDomain != null && this.affectedObjectsListener != null) {
            IOperationHistory operationHistory = ((IWorkspaceCommandStack)editingDomain.getCommandStack()).getOperationHistory();
            operationHistory.removeOperationHistoryListener(this.affectedObjectsListener);
        }
    }

    protected IOperationHistoryListener createAffectedObjectsListener() {
        return new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                IUndoableOperation operation = event.getOperation();
                if (event.getEventType() == 1) {
                    this.handleOperationAboutToExecute(operation);
                } else if (event.getEventType() == 4 || event.getEventType() == 10 || event.getEventType() == 9) {
                    boolean isRightResourceAffected;
                    Set affectedResources = ResourceUndoContext.getAffectedResources((IUndoableOperation)operation);
                    Resource[] resources = ModelCompareEditor.this.getModelRootsResources();
                    boolean isLeftResourceAffected = resources[0] != null ? affectedResources.contains(resources[0]) : false;
                    boolean bl = isRightResourceAffected = resources[1] != null ? affectedResources.contains(resources[1]) : false;
                    if (isLeftResourceAffected || isRightResourceAffected) {
                        this.handleOperationFinished(operation);
                    }
                }
            }

            private void handleOperationAboutToExecute(final IUndoableOperation operation) {
                IWorkbenchPartSite site;
                if (operation.canUndo() && (site = ModelCompareEditor.this.getSite()) != null) {
                    site.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if (ModelCompareEditor.this.isActivePart()) {
                                Resource[] resources;
                                Resource[] resourceArray = resources = ModelCompareEditor.this.getModelRootsResources();
                                int n = resources.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IWorkspaceCommandStack cmdStack;
                                    IUndoContext defaultUndoContext;
                                    Resource resource = resourceArray[n2];
                                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)resource);
                                    if (editingDomain != null && editingDomain.getCommandStack() instanceof IWorkspaceCommandStack && (defaultUndoContext = (cmdStack = (IWorkspaceCommandStack)editingDomain.getCommandStack()).getDefaultUndoContext()) != null) {
                                        operation.removeContext(defaultUndoContext);
                                    }
                                    ++n2;
                                }
                                operation.addContext(ModelCompareEditor.this.getUndoContext());
                            }
                        }
                    });
                }
            }

            private void handleOperationFinished(IUndoableOperation operation) {
                ModelCompareEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                    }
                });
            }
        };
    }

    public ISaveablesLifecycleListener createModelSaveablesLifecycleListener() {
        return new BasicModelSaveablesProvider.SiteNotifyingSaveablesLifecycleListener((IWorkbenchPart)this){

            public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
                super.handleLifecycleEvent(event);
                if (event.getEventType() == 4) {
                    ModelCompareEditor.this.firePropertyChange(257);
                }
            }
        };
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IUndoContext.class)) {
            return this.getUndoContext();
        }
        return super.getAdapter(key);
    }

    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    public TransactionalEditingDomain[] getEditingDomains() {
        TransactionalEditingDomain[] editingDomains = new TransactionalEditingDomain[2];
        EObject[] modelRoots = this.getModelRoots();
        if (modelRoots[0] != null) {
            editingDomains[0] = WorkspaceEditingDomainUtil.getEditingDomain((Object)modelRoots[0]);
        }
        if (modelRoots[1] != null) {
            editingDomains[1] = WorkspaceEditingDomainUtil.getEditingDomain((Object)modelRoots[1]);
        }
        if (editingDomains[0] == null && editingDomains[1] == null) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)new RuntimeException("No editing domain found"));
        }
        return editingDomains;
    }

    protected IOperationHistory[] getOperationHistories() {
        IOperationHistory[] operationHistories = new IOperationHistory[2];
        TransactionalEditingDomain[] editingDomains = this.getEditingDomains();
        int i = 0;
        while (i < 2) {
            if (editingDomains[i] != null) {
                operationHistories[i] = ((IWorkspaceCommandStack)editingDomains[i].getCommandStack()).getOperationHistory();
            }
            ++i;
        }
        return operationHistories;
    }

    public EObject[] getModelRoots() {
        EObject[] modelRoots = new EObject[2];
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof ModelElementCompareEditorInput) {
            modelRoots = ((ModelElementCompareEditorInput)editorInput).getModelRoots();
        }
        return modelRoots;
    }

    protected Resource[] getModelRootsResources() {
        Resource[] resources = new Resource[2];
        EObject[] modelRoots = this.getModelRoots();
        int i = 0;
        while (i < 2) {
            EObject modelRoot = modelRoots[i];
            if (modelRoot != null) {
                resources[i] = modelRoot.eResource();
            }
            ++i;
        }
        return resources;
    }

    protected String getModelRootsNames() {
        String[] labels = new String[2];
        EObject[] modelRoots = this.getModelRoots();
        AdapterFactoryItemDelegator[] itemDelegators = this.getItemDelegators();
        int i = 0;
        while (i < 2) {
            if (modelRoots[i] != null && itemDelegators[i] != null) {
                labels[i] = itemDelegators[i].getText((Object)modelRoots[i]);
            }
            ++i;
        }
        if (labels[0] != null && labels[1] != null) {
            return String.valueOf(labels[0]) + " <---> " + labels[1];
        }
        return ((CompareEditorInput)this.getEditorInput()).getTitle();
    }

    protected AdapterFactory[] getAdapterFactories() {
        AdapterFactory[] adapterFactories = new AdapterFactory[2];
        TransactionalEditingDomain[] editingDomains = this.getEditingDomains();
        int i = 0;
        while (i < 2) {
            TransactionalEditingDomain editingDomain = editingDomains[i];
            if (editingDomain != null) {
                adapterFactories[i] = ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
            }
            ++i;
        }
        return adapterFactories;
    }

    protected AdapterFactoryItemDelegator[] getItemDelegators() {
        AdapterFactoryItemDelegator[] itemDelegators = new AdapterFactoryItemDelegator[2];
        AdapterFactory[] adapterFactories = this.getAdapterFactories();
        int i = 0;
        while (i < 2) {
            AdapterFactory adapterFactory = adapterFactories[i];
            if (adapterFactory != null) {
                itemDelegators[i] = new AdapterFactoryItemDelegator(adapterFactory);
            }
            ++i;
        }
        return itemDelegators;
    }

    protected boolean isActivePart() {
        return this == this.getSite().getWorkbenchWindow().getPartService().getActivePart();
    }

    public void setInput(IEditorInput input) {
        if (input instanceof ModelElementCompareEditorInput) {
            super.setInput(input);
        } else {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)new RuntimeException(Messages.error_invalidEditorInput));
        }
    }
}

