/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.internal.loading;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.workspace.internal.loading.FileLoadJob;
import org.eclipse.sphinx.emf.workspace.internal.loading.ModelLoadJob;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoadJob
extends Job {
    protected IMetaModelDescriptor fMMDescriptor;
    protected static int DIFFERENT = 0;
    protected static int EQUAL = 1;
    protected static int GREATER_THAN = 2;
    protected static int SMALLER_THAN = 3;

    protected LoadJob(String name, IMetaModelDescriptor mmDescriptor) {
        super(name);
        this.fMMDescriptor = mmDescriptor;
    }

    static int compare(IMetaModelDescriptor mmd1, IMetaModelDescriptor mmd2) {
        if (mmd1 == null || MetaModelDescriptorRegistry.ANY_MM.equals(mmd1)) {
            if (mmd2 == null || MetaModelDescriptorRegistry.ANY_MM.equals(mmd2)) {
                return EQUAL;
            }
            return GREATER_THAN;
        }
        if (mmd2 == null || MetaModelDescriptorRegistry.ANY_MM.equals(mmd2)) {
            return SMALLER_THAN;
        }
        if (mmd1.getClass().isAssignableFrom(mmd2.getClass())) {
            return GREATER_THAN;
        }
        if (mmd2.getClass().isAssignableFrom(mmd1.getClass())) {
            return SMALLER_THAN;
        }
        return DIFFERENT;
    }

    static <T> int compare(Collection<T> list1, Collection<T> list2) {
        int from1ContainedIn2 = 0;
        int from2ContainedIn1 = 0;
        for (T o : list1) {
            if (!list2.contains(o)) continue;
            ++from1ContainedIn2;
        }
        for (T o : list2) {
            if (!list1.contains(o)) continue;
            ++from2ContainedIn1;
        }
        if (from1ContainedIn2 == from2ContainedIn1 && from1ContainedIn2 == list1.size() && from2ContainedIn1 == list2.size()) {
            return EQUAL;
        }
        if (from1ContainedIn2 == list1.size()) {
            return SMALLER_THAN;
        }
        if (from2ContainedIn1 == list2.size()) {
            return GREATER_THAN;
        }
        return DIFFERENT;
    }

    public static boolean shouldCreateJob(Collection<IFile> files, IMetaModelDescriptor mmDescriptor) {
        HashSet<IProject> projects = new HashSet<IProject>();
        for (IFile file : files) {
            projects.add(file.getProject());
        }
        Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (job instanceof ModelLoadJob ? ((ModelLoadJob)job).covers(projects, false, null) : job instanceof FileLoadJob && ((FileLoadJob)job).covers(files, mmDescriptor)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean shouldCreateJob(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor) {
        Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (job instanceof ModelLoadJob && ((ModelLoadJob)job).covers(projects, includeReferencedProjects, mmDescriptor)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

