/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.groups;

import org.eclipse.core.resources.IProject;
import org.eclipse.sphinx.platform.ui.fields.SelectionButtonField;
import org.eclipse.sphinx.platform.ui.fields.StringField;
import org.eclipse.sphinx.platform.ui.groups.AbstractGroup;
import org.eclipse.sphinx.xtendxpand.preferences.PrDefaultExcludesPreference;
import org.eclipse.sphinx.xtendxpand.preferences.PrExcludesPreference;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ProtectedRegionGroup
extends AbstractGroup {
    private IProject project;
    private StringField prExcludesField;
    private SelectionButtonField prDefaultExcludesField;

    public ProtectedRegionGroup(String groupName, IProject project) {
        super(groupName);
        this.project = project;
    }

    protected void doCreateContent(Composite parent, int numColumns) {
        parent.setLayout((Layout)new GridLayout(numColumns, false));
        this.prExcludesField = new StringField();
        this.prExcludesField.setLabelText(Messages.label_prExcludes);
        this.prExcludesField.fillIntoGrid(parent, 3);
        this.prExcludesField.setTextWithoutUpdate((String)PrExcludesPreference.INSTANCE.get(this.project));
        this.prExcludesField.setToolTipText(Messages.tooltip_prExcludesField);
        this.prDefaultExcludesField = new SelectionButtonField(32);
        this.prDefaultExcludesField.setLabelText(Messages.label_prDefaultExcludes);
        this.prDefaultExcludesField.fillIntoGrid(parent, 3);
        this.prDefaultExcludesField.setSelectionWithoutEvent(((Boolean)PrDefaultExcludesPreference.INSTANCE.get(this.project)).booleanValue());
        this.prDefaultExcludesField.setToolTipText(Messages.tooltip_prDefaultExcludes);
    }

    public void setToDefault() {
        this.prExcludesField.setTextWithoutUpdate((String)PrExcludesPreference.INSTANCE.getDefaultValueAsObject());
        this.prDefaultExcludesField.setSelectionWithoutEvent(((Boolean)PrDefaultExcludesPreference.INSTANCE.getDefaultValueAsObject()).booleanValue());
    }

    public void store() {
        if (this.project != null) {
            PrExcludesPreference.INSTANCE.setInProject(this.project, (Object)this.prExcludesField.getText());
            PrDefaultExcludesPreference.INSTANCE.setInProject(this.project, (Object)this.prDefaultExcludesField.isSelected());
        } else {
            PrExcludesPreference.INSTANCE.setInWorkspace((Object)this.prExcludesField.getText());
            PrDefaultExcludesPreference.INSTANCE.setInWorkspace((Object)this.prDefaultExcludesField.isSelected());
        }
    }

    public void dispose() {
        this.prExcludesField.dispose();
        this.prDefaultExcludesField.dispose();
    }
}

