/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.resource;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.resource.ExtendedResource;
import org.eclipse.sphinx.emf.resource.ExtendedResourceAdapterFactory;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ExtendedSAXXMIHandler
extends SAXXMIHandler {
    protected static final String XMI_VERSION_ATTRIBUTE = "xmi:version";
    protected ExtendedResource extendedResource = ExtendedResourceAdapterFactory.INSTANCE.adapt((Resource)this.xmlResource);
    protected IMetaModelDescriptor resourceVersion = null;
    protected boolean recordLineAndColumnNumbers;

    public ExtendedSAXXMIHandler(XMLResource xmiResource, XMLHelper helper, Map<?, ?> options) {
        super(xmiResource, helper, options);
        Object value = options.get("RESOURCE_VERSION_DESCRIPTOR");
        if (value instanceof IMetaModelDescriptor) {
            this.resourceVersion = (IMetaModelDescriptor)value;
        }
        if (options.get("OPTION_RECORD_LINE_AND_COLUMN_NUMBERS") == Boolean.TRUE) {
            this.recordLineAndColumnNumbers = true;
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            return super.resolveEntity(publicId, systemId);
        }
        catch (SAXException ex) {
            String lastSegment = URI.createURI((String)systemId).lastSegment();
            if (lastSegment != null) {
                try {
                    URI uri = URI.createURI((String)lastSegment);
                    uri = this.helper.resolve(uri, this.resourceURI);
                    InputStream inputStream = this.getURIConverter().createInputStream(uri, null);
                    InputSource result = new InputSource(inputStream);
                    result.setPublicId(publicId);
                    result.setSystemId(systemId);
                    return result;
                }
                catch (Exception uri) {
                    // empty catch block
                }
            }
            String resourceNamespace = null;
            resourceNamespace = this.resourceVersion != null ? this.resourceVersion.getNamespace() : EcoreResourceUtil.readModelNamespace((Resource)this.xmlResource);
            if (resourceNamespace != null) {
                try {
                    URI uri = URI.createURI((String)resourceNamespace);
                    uri = this.helper.resolve(uri, this.resourceURI);
                    InputStream inputStream = this.getURIConverter().createInputStream(uri, null);
                    InputSource result = new InputSource(inputStream);
                    result.setPublicId(publicId);
                    result.setSystemId(systemId);
                    return result;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    protected URIConverter getURIConverter() {
        return EcoreResourceUtil.getURIConverter(this.resourceSet);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        try {
            super.fatalError(e);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    protected void processTopObject(EObject object) {
        if (object != null) {
            if (this.deferredExtent != null) {
                this.deferredExtent.add(object);
            } else {
                this.extent.addUnique((Object)object);
            }
            if (this.extendedMetaData != null && !this.mixedTargets.isEmpty()) {
                FeatureMap featureMap = (FeatureMap)this.mixedTargets.pop();
                EAttribute target = null;
                EList allAttributes = object.eClass().getEAllAttributes();
                for (Object element : allAttributes) {
                    EAttribute attribute = (EAttribute)element;
                    if (!"mixedOuterContent".equals(attribute.getName())) continue;
                    target = attribute;
                    break;
                }
                if (target == null) {
                    target = this.extendedMetaData.getMixedFeature(object.eClass());
                }
                if (target != null) {
                    FeatureMap otherFeatureMap = (FeatureMap)object.eGet(target);
                    for (FeatureMap.Entry entry : new ArrayList(featureMap)) {
                        if (entry.getEStructuralFeature() == XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT && "".equals(XMLTypeUtil.normalize((String)entry.getValue().toString(), (boolean)true))) continue;
                        otherFeatureMap.add(entry.getEStructuralFeature(), entry.getValue());
                    }
                }
                this.text = null;
            }
        }
        this.processObject(object);
    }

    protected void handleProxy(InternalEObject proxy, String uriLiteral) {
        URI proxyURI;
        if (this.oldStyleProxyURIs) {
            uriLiteral = uriLiteral.startsWith("/") ? uriLiteral : "/" + uriLiteral;
            proxyURI = URI.createURI((String)uriLiteral);
            proxy.eSetProxyURI(proxyURI);
        } else {
            proxyURI = this.extendedResource != null ? this.extendedResource.createURI(uriLiteral, proxy.eClass()) : URI.createURI((String)uriLiteral);
            if (this.uriHandler != null) {
                proxyURI = this.uriHandler.resolve(proxyURI);
            } else if (this.resolve && proxyURI.isRelative() && proxyURI.hasRelativePath() && (this.extendedMetaData == null ? !this.packageRegistry.containsKey((Object)proxyURI.trimFragment().toString()) : this.extendedMetaData.getPackage(proxyURI.trimFragment().toString()) == null)) {
                proxyURI = this.helper.resolve(proxyURI, this.resourceURI);
            }
            proxy.eSetProxyURI(proxyURI);
        }
        if (proxyURI.trimFragment().equals(this.resourceURI)) {
            this.sameDocumentProxies.add(proxy);
        }
        if (this.extendedResource != null) {
            this.extendedResource.augmentToContextAwareProxy((EObject)proxy);
        }
    }

    protected void handleObjectAttribs(EObject obj) {
        if (this.attribs != null) {
            InternalEObject internalEObject = (InternalEObject)obj;
            int i = 0;
            int size = this.attribs.getLength();
            while (i < size) {
                String name = this.attribs.getQName(i);
                if (name.equals("xmi:id")) {
                    this.xmlResource.setID((EObject)internalEObject, this.attribs.getValue(i));
                } else if (name.equals(this.hrefAttribute) && (!this.recordUnknownFeature || this.types.peek() != "unknownFeature" || obj.eClass() != this.anyType)) {
                    this.handleProxy(internalEObject, this.attribs.getValue(i));
                } else if (this.isNamespaceAware) {
                    String namespace = this.attribs.getURI(i);
                    if (!("http://www.omg.org/XMI".equals(namespace) && "version".equals(name) || "http://www.w3.org/2001/XMLSchema-instance".equals(namespace) || this.notFeatures.contains(name))) {
                        this.setAttribValue(obj, name, this.attribs.getValue(i));
                    }
                } else if (!name.startsWith("xmlns") && !this.notFeatures.contains(name)) {
                    this.setAttribValue(obj, name, this.attribs.getValue(i));
                }
                ++i;
            }
        }
        if (this.recordLineAndColumnNumbers) {
            AnyType extension = this.getExtension(obj);
            EStructuralFeature lineNumberAttribute = this.extendedMetaData.demandFeature(null, "lineNumber", false);
            extension.eSet(lineNumberAttribute, (Object)this.getLineNumber());
            EStructuralFeature columnAttribute = this.extendedMetaData.demandFeature(null, "columnNumber", false);
            extension.eSet(columnAttribute, (Object)this.getColumnNumber());
        }
    }
}

