/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.sphinx.emf.check.util.CheckValidationContextHelper;
import org.eclipse.sphinx.emf.check.util.ExtendedEObjectValidator;
import org.eclipse.sphinx.emf.validation.ICompositeValidator;

public class CompositeValidator
implements ICompositeValidator {
    private List<EValidator> validators = new ArrayList<EValidator>();

    public CompositeValidator() {
    }

    public CompositeValidator(EValidator validator) {
        this();
        this.addValidator(validator);
    }

    public void addValidator(EValidator validator) {
        if (this == validator) {
            return;
        }
        if (!this.validators.contains(validator)) {
            this.validators.add(validator);
        }
    }

    public void removeValidator(EValidator validator) {
        if (this == validator) {
            return;
        }
        if (this.validators.contains(validator)) {
            this.validators.remove(validator);
        }
    }

    public List<EValidator> getValidators() {
        return this.validators;
    }

    protected boolean containsEObjectValidator() {
        for (EValidator validator : this.getValidators()) {
            if (!(validator instanceof EObjectValidator)) continue;
            return true;
        }
        return false;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CompositeValidatorHandler handler = new CompositeValidatorHandler(context);
        boolean result = handler.preValidate(eObject.eClass().getClassifierID(), eObject, diagnostics);
        for (EValidator validator : this.getValidators()) {
            result &= validator.validate(eObject, diagnostics, context);
        }
        handler.postValidate();
        return result;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CompositeValidatorHandler handler = new CompositeValidatorHandler(context);
        boolean result = handler.preValidate(eClass.getClassifierID(), eObject, diagnostics);
        for (EValidator validator : this.getValidators()) {
            result &= validator.validate(eClass, eObject, diagnostics, context);
        }
        handler.postValidate();
        return result;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CompositeValidatorHandler handler = new CompositeValidatorHandler(context);
        boolean result = handler.preValidate(eDataType.getClassifierID(), value, diagnostics);
        for (EValidator validator : this.getValidators()) {
            result &= validator.validate(eDataType, value, diagnostics, context);
        }
        handler.postValidate();
        return result;
    }

    protected class CompositeValidatorHandler {
        private ExtendedEObjectValidator eObjectValidator = new ExtendedEObjectValidator();
        private Map<Object, Object> context;
        private CheckValidationContextHelper helper;
        private Boolean oldEnableIntrinsicModelIntegrityConstraintsOption = null;

        public CompositeValidatorHandler(Map<Object, Object> context) {
            this.context = context;
            this.helper = new CheckValidationContextHelper(context);
        }

        public boolean preValidate(int classifierID, Object object, DiagnosticChain diagnostics) {
            boolean result = true;
            if (this.helper.areIntrinsicModelIntegrityConstraintsEnabled() && !CompositeValidator.this.containsEObjectValidator()) {
                result = this.eObjectValidator.validate(classifierID, object, diagnostics, this.context);
                this.oldEnableIntrinsicModelIntegrityConstraintsOption = this.helper.removeEnableIntrinsicModelIntegrityConstraintsOption();
            }
            return result;
        }

        public void postValidate() {
            this.helper.addEnableIntrinsicModelIntegrityConstraintsOption(this.oldEnableIntrinsicModelIntegrityConstraintsOption);
        }
    }
}

