/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.search.ui.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.search.ui.ModelSearchMatch;
import org.eclipse.sphinx.emf.search.ui.QuerySpecification;
import org.eclipse.sphinx.emf.search.ui.services.IModelSearchService;
import org.eclipse.sphinx.emf.ui.util.RetrieveNameAttributeHelper;

public class BasicModelSearchService
implements IModelSearchService {
    private RetrieveNameAttributeHelper helper = new RetrieveNameAttributeHelper();

    @Override
    public List<ModelSearchMatch> getMatches(IModelDescriptor modelDescriptor, QuerySpecification spec) {
        return this.getMatches(modelDescriptor.getLoadedResources(true), spec);
    }

    @Override
    public List<ModelSearchMatch> getMatches(Collection<Resource> resources, QuerySpecification spec) {
        ArrayList<ModelSearchMatch> result = new ArrayList<ModelSearchMatch>();
        for (Resource resource : resources) {
            TreeIterator allContents = resource.getAllContents();
            while (allContents.hasNext()) {
                Object name;
                EObject eObject = (EObject)allContents.next();
                EAttribute nameAttribute = this.helper.getNameAttribute(eObject);
                if (nameAttribute == null || (name = eObject.eGet((EStructuralFeature)nameAttribute)) == null) continue;
                if (spec.isCaseSensitive()) {
                    if (!name.toString().equals(spec.getPattern())) continue;
                    result.add(this.createModelSearchMatch(eObject));
                    continue;
                }
                if (!name.toString().equalsIgnoreCase(spec.getPattern())) continue;
                result.add(this.createModelSearchMatch(eObject));
            }
        }
        return result;
    }

    private ModelSearchMatch createModelSearchMatch(EObject eObject) {
        ModelSearchMatch match = new ModelSearchMatch(eObject);
        return match;
    }
}

