/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.mutiny.core.http.ClientWebSocket;
import io.vertx.mutiny.core.http.WebSocket;
import io.vertx.mutiny.core.metrics.Measured;

@MutinyGen(value=io.vertx.core.http.WebSocketClient.class)
public class WebSocketClient
implements Measured {
    public static final TypeArg<WebSocketClient> __TYPE_ARG = new TypeArg<WebSocketClient>(obj -> new WebSocketClient((io.vertx.core.http.WebSocketClient)obj), WebSocketClient::getDelegate);
    private final io.vertx.core.http.WebSocketClient delegate;

    public WebSocketClient(io.vertx.core.http.WebSocketClient delegate) {
        this.delegate = delegate;
    }

    public WebSocketClient(Object delegate) {
        this.delegate = (io.vertx.core.http.WebSocketClient)delegate;
    }

    WebSocketClient() {
        this.delegate = null;
    }

    @Override
    public io.vertx.core.http.WebSocketClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketClient that = (WebSocketClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public ClientWebSocket webSocket() {
        ClientWebSocket ret = ClientWebSocket.newInstance(this.delegate.webSocket());
        return ret;
    }

    @CheckReturnValue
    public Uni<WebSocket> connect(int port, String host, String requestURI) {
        return AsyncResultUni.toUni(handler -> this.delegate.connect(port, host, requestURI, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    public WebSocket connectAndAwait(int port, String host, String requestURI) {
        return this.connect(port, host, requestURI).await().indefinitely();
    }

    public void connectAndForget(int port, String host, String requestURI) {
        this.connect(port, host, requestURI).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<WebSocket> connect(String host, String requestURI) {
        return AsyncResultUni.toUni(handler -> this.delegate.connect(host, requestURI, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    public WebSocket connectAndAwait(String host, String requestURI) {
        return this.connect(host, requestURI).await().indefinitely();
    }

    public void connectAndForget(String host, String requestURI) {
        this.connect(host, requestURI).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<WebSocket> connect(String requestURI) {
        return AsyncResultUni.toUni(handler -> this.delegate.connect(requestURI, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    public WebSocket connectAndAwait(String requestURI) {
        return this.connect(requestURI).await().indefinitely();
    }

    public void connectAndForget(String requestURI) {
        this.connect(requestURI).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<WebSocket> connect(WebSocketConnectOptions options) {
        return AsyncResultUni.toUni(handler -> this.delegate.connect(options, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    public WebSocket connectAndAwait(WebSocketConnectOptions options) {
        return this.connect(options).await().indefinitely();
    }

    public void connectAndForget(WebSocketConnectOptions options) {
        this.connect(options).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Boolean> updateSSLOptions(SSLOptions options) {
        return AsyncResultUni.toUni(handler -> this.delegate.updateSSLOptions(options, (Handler<AsyncResult<Boolean>>)handler));
    }

    public Boolean updateSSLOptionsAndAwait(SSLOptions options) {
        return this.updateSSLOptions(options).await().indefinitely();
    }

    public void updateSSLOptionsAndForget(SSLOptions options) {
        this.updateSSLOptions(options).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Boolean> updateSSLOptions(SSLOptions options, boolean force) {
        return AsyncResultUni.toUni(handler -> this.delegate.updateSSLOptions(options, force, (Handler<AsyncResult<Boolean>>)handler));
    }

    public Boolean updateSSLOptionsAndAwait(SSLOptions options, boolean force) {
        return this.updateSSLOptions(options, force).await().indefinitely();
    }

    public void updateSSLOptionsAndForget(SSLOptions options, boolean force) {
        this.updateSSLOptions(options, force).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public static WebSocketClient newInstance(io.vertx.core.http.WebSocketClient arg) {
        return arg != null ? new WebSocketClient(arg) : null;
    }
}

