/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public final class InterceptorBindings {
    private final Set<String> allInterceptorBindings;
    private final Map<Class<? extends Annotation>, Set<Annotation>> transitiveInterceptorBindings;

    InterceptorBindings(Set<String> interceptorBindings, Map<Class<? extends Annotation>, Set<Annotation>> transitiveInterceptorBindings) {
        this.allInterceptorBindings = interceptorBindings;
        this.transitiveInterceptorBindings = transitiveInterceptorBindings;
    }

    boolean isRegistered(Class<? extends Annotation> annotationType) {
        return this.allInterceptorBindings.contains(annotationType.getName());
    }

    Set<Annotation> getTransitive(Class<? extends Annotation> interceptorBinding) {
        return this.transitiveInterceptorBindings.get(interceptorBinding);
    }

    void verify(Annotation[] interceptorBindings) {
        if (interceptorBindings.length == 0) {
            return;
        }
        if (interceptorBindings.length == 1) {
            this.verifyInterceptorBinding(interceptorBindings[0].annotationType());
        } else {
            HashMap<Class<? extends Annotation>, Integer> timesQualifierWasSeen = new HashMap<Class<? extends Annotation>, Integer>();
            for (Annotation interceptorBinding : interceptorBindings) {
                this.verifyInterceptorBinding(interceptorBinding.annotationType());
                timesQualifierWasSeen.compute(interceptorBinding.annotationType(), TimesSeenBiFunction.INSTANCE);
            }
            InterceptorBindings.checkInterceptorBindingsForDuplicates(timesQualifierWasSeen);
        }
    }

    private static void checkInterceptorBindingsForDuplicates(Map<Class<? extends Annotation>, Integer> timesSeen) {
        timesSeen.forEach(InterceptorBindings::checkInterceptorBindingsForDuplicates);
    }

    private static void checkInterceptorBindingsForDuplicates(Class<? extends Annotation> annClass, Integer timesSeen) {
        if (timesSeen > 1 && !annClass.isAnnotationPresent(Repeatable.class)) {
            throw new IllegalArgumentException("Interceptor binding " + annClass + " was used repeatedly but is not @Repeatable");
        }
    }

    private void verifyInterceptorBinding(Class<? extends Annotation> annotationType) {
        if (!this.allInterceptorBindings.contains(annotationType.getName())) {
            throw new IllegalArgumentException("Annotation is not a registered interceptor binding: " + annotationType);
        }
    }

    private static class TimesSeenBiFunction
    implements BiFunction<Class<? extends Annotation>, Integer, Integer> {
        private static final TimesSeenBiFunction INSTANCE = new TimesSeenBiFunction();

        private TimesSeenBiFunction() {
        }

        @Override
        public Integer apply(Class<? extends Annotation> k, Integer v) {
            return v == null ? 1 : v + 1;
        }
    }
}

