/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.client.RequestConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RequestConfigFluent<A extends RequestConfigFluent<A>>
extends BaseFluent<A> {
    private String impersonateUsername;
    private List<String> impersonateGroups;
    private Map<String, List<String>> impersonateExtras;
    private int watchReconnectInterval;
    private int watchReconnectLimit;
    private int uploadRequestTimeout;
    private int requestRetryBackoffLimit;
    private int requestRetryBackoffInterval;
    private int requestTimeout;
    private long scaleTimeout;
    private int loggingInterval;

    public RequestConfigFluent() {
    }

    public RequestConfigFluent(RequestConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RequestConfig instance) {
        RequestConfig requestConfig = instance = instance != null ? instance : new RequestConfig();
        if (instance != null) {
            this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
            this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
            this.withRequestTimeout(instance.getRequestTimeout());
            this.withScaleTimeout(instance.getScaleTimeout());
            this.withLoggingInterval(instance.getLoggingInterval());
            this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
            this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
            this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
            this.withImpersonateUsername(instance.getImpersonateUsername());
            this.withImpersonateGroups(instance.getImpersonateGroups());
            this.withImpersonateExtras(instance.getImpersonateExtras());
        }
    }

    public String getImpersonateUsername() {
        return this.impersonateUsername;
    }

    public A withImpersonateUsername(String impersonateUsername) {
        this.impersonateUsername = impersonateUsername;
        return (A)this;
    }

    public boolean hasImpersonateUsername() {
        return this.impersonateUsername != null;
    }

    public A withImpersonateGroups(String ... impersonateGroups) {
        if (this.impersonateGroups != null) {
            this.impersonateGroups.clear();
            this._visitables.remove("impersonateGroups");
        }
        if (impersonateGroups != null) {
            for (String item : impersonateGroups) {
                this.addToImpersonateGroups(item);
            }
        }
        return (A)this;
    }

    public String[] getImpersonateGroups() {
        int size = this.impersonateGroups != null ? this.impersonateGroups.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.impersonateGroups) {
            result[index++] = item;
        }
        return result;
    }

    public A addToImpersonateGroups(int index, String item) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        this.impersonateGroups.add(index, item);
        return (A)this;
    }

    public A setToImpersonateGroups(int index, String item) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        this.impersonateGroups.set(index, item);
        return (A)this;
    }

    public A addToImpersonateGroups(String ... items) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)this;
    }

    public A addAllToImpersonateGroups(Collection<String> items) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)this;
    }

    public A removeFromImpersonateGroups(String ... items) {
        if (this.impersonateGroups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.impersonateGroups.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromImpersonateGroups(Collection<String> items) {
        if (this.impersonateGroups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.impersonateGroups.remove(item);
        }
        return (A)this;
    }

    public boolean hasImpersonateGroups() {
        return this.impersonateGroups != null && !this.impersonateGroups.isEmpty();
    }

    public A addToImpersonateExtras(String key, List<String> value) {
        if (this.impersonateExtras == null && key != null && value != null) {
            this.impersonateExtras = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.impersonateExtras.put(key, value);
        }
        return (A)this;
    }

    public A addToImpersonateExtras(Map<String, List<String>> map) {
        if (this.impersonateExtras == null && map != null) {
            this.impersonateExtras = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.impersonateExtras.putAll(map);
        }
        return (A)this;
    }

    public A removeFromImpersonateExtras(String key) {
        if (this.impersonateExtras == null) {
            return (A)this;
        }
        if (key != null && this.impersonateExtras != null) {
            this.impersonateExtras.remove(key);
        }
        return (A)this;
    }

    public A removeFromImpersonateExtras(Map<String, List<String>> map) {
        if (this.impersonateExtras == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.impersonateExtras == null) continue;
                this.impersonateExtras.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, List<String>> getImpersonateExtras() {
        return this.impersonateExtras;
    }

    public <K, V> A withImpersonateExtras(Map<String, List<String>> impersonateExtras) {
        this.impersonateExtras = impersonateExtras == null ? null : new LinkedHashMap<String, List<String>>(impersonateExtras);
        return (A)this;
    }

    public boolean hasImpersonateExtras() {
        return this.impersonateExtras != null;
    }

    public int getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    public A withWatchReconnectInterval(int watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
        return (A)this;
    }

    public boolean hasWatchReconnectInterval() {
        return true;
    }

    public int getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    public A withWatchReconnectLimit(int watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
        return (A)this;
    }

    public boolean hasWatchReconnectLimit() {
        return true;
    }

    public int getUploadRequestTimeout() {
        return this.uploadRequestTimeout;
    }

    public A withUploadRequestTimeout(int uploadRequestTimeout) {
        this.uploadRequestTimeout = uploadRequestTimeout;
        return (A)this;
    }

    public boolean hasUploadRequestTimeout() {
        return true;
    }

    public int getRequestRetryBackoffLimit() {
        return this.requestRetryBackoffLimit;
    }

    public A withRequestRetryBackoffLimit(int requestRetryBackoffLimit) {
        this.requestRetryBackoffLimit = requestRetryBackoffLimit;
        return (A)this;
    }

    public boolean hasRequestRetryBackoffLimit() {
        return true;
    }

    public int getRequestRetryBackoffInterval() {
        return this.requestRetryBackoffInterval;
    }

    public A withRequestRetryBackoffInterval(int requestRetryBackoffInterval) {
        this.requestRetryBackoffInterval = requestRetryBackoffInterval;
        return (A)this;
    }

    public boolean hasRequestRetryBackoffInterval() {
        return true;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public A withRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (A)this;
    }

    public boolean hasRequestTimeout() {
        return true;
    }

    public long getScaleTimeout() {
        return this.scaleTimeout;
    }

    public A withScaleTimeout(long scaleTimeout) {
        this.scaleTimeout = scaleTimeout;
        return (A)this;
    }

    public boolean hasScaleTimeout() {
        return true;
    }

    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    public A withLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
        return (A)this;
    }

    public boolean hasLoggingInterval() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestConfigFluent that = (RequestConfigFluent)o;
        if (!Objects.equals(this.impersonateUsername, that.impersonateUsername)) {
            return false;
        }
        if (!Objects.equals(this.impersonateGroups, that.impersonateGroups)) {
            return false;
        }
        if (!Objects.equals(this.impersonateExtras, that.impersonateExtras)) {
            return false;
        }
        if (this.watchReconnectInterval != that.watchReconnectInterval) {
            return false;
        }
        if (this.watchReconnectLimit != that.watchReconnectLimit) {
            return false;
        }
        if (this.uploadRequestTimeout != that.uploadRequestTimeout) {
            return false;
        }
        if (this.requestRetryBackoffLimit != that.requestRetryBackoffLimit) {
            return false;
        }
        if (this.requestRetryBackoffInterval != that.requestRetryBackoffInterval) {
            return false;
        }
        if (this.requestTimeout != that.requestTimeout) {
            return false;
        }
        if (this.scaleTimeout != that.scaleTimeout) {
            return false;
        }
        return this.loggingInterval == that.loggingInterval;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.impersonateUsername, this.impersonateGroups, this.impersonateExtras, this.watchReconnectInterval, this.watchReconnectLimit, this.uploadRequestTimeout, this.requestRetryBackoffLimit, this.requestRetryBackoffInterval, this.requestTimeout, this.scaleTimeout, this.loggingInterval, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.impersonateUsername != null) {
            sb.append("impersonateUsername:");
            sb.append(this.impersonateUsername + ",");
        }
        if (this.impersonateGroups != null && !this.impersonateGroups.isEmpty()) {
            sb.append("impersonateGroups:");
            sb.append(this.impersonateGroups + ",");
        }
        if (this.impersonateExtras != null && !this.impersonateExtras.isEmpty()) {
            sb.append("impersonateExtras:");
            sb.append(this.impersonateExtras + ",");
        }
        sb.append("watchReconnectInterval:");
        sb.append(this.watchReconnectInterval + ",");
        sb.append("watchReconnectLimit:");
        sb.append(this.watchReconnectLimit + ",");
        sb.append("uploadRequestTimeout:");
        sb.append(this.uploadRequestTimeout + ",");
        sb.append("requestRetryBackoffLimit:");
        sb.append(this.requestRetryBackoffLimit + ",");
        sb.append("requestRetryBackoffInterval:");
        sb.append(this.requestRetryBackoffInterval + ",");
        sb.append("requestTimeout:");
        sb.append(this.requestTimeout + ",");
        sb.append("scaleTimeout:");
        sb.append(this.scaleTimeout + ",");
        sb.append("loggingInterval:");
        sb.append(this.loggingInterval);
        sb.append("}");
        return sb.toString();
    }
}

