/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.config;

import java.util.Objects;
import org.eclipse.hono.client.amqp.config.ClientConfigProperties;
import org.eclipse.hono.util.Strings;

public class AddressHelper {
    private AddressHelper() {
    }

    public static String getTargetAddress(String endpoint, String tenantId, String resourceId, ClientConfigProperties config) {
        StringBuilder addressBuilder = new StringBuilder(Objects.requireNonNull(endpoint)).append("/").append(Objects.requireNonNull(tenantId));
        if (!Strings.isNullOrEmpty(resourceId)) {
            addressBuilder.append("/").append(resourceId);
        }
        return AddressHelper.rewrite(addressBuilder.toString(), config);
    }

    public static String rewrite(String address, ClientConfigProperties config) {
        if (config != null && config.getAddressRewritePattern() != null && !Strings.isNullOrEmpty(config.getAddressRewriteReplacement())) {
            return config.getAddressRewritePattern().matcher(address).replaceAll(config.getAddressRewriteReplacement());
        }
        return address;
    }
}

