/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.nio.charset.StandardCharsets;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorLoggingCallback
implements Callback {
    private static final Logger log = LoggerFactory.getLogger(ErrorLoggingCallback.class);
    private String topic;
    private byte[] key;
    private byte[] value;
    private int valueLength;
    private boolean logAsString;

    public ErrorLoggingCallback(String topic, byte[] key, byte[] value, boolean logAsString) {
        this.topic = topic;
        this.key = key;
        if (logAsString) {
            this.value = value;
        }
        this.valueLength = value == null ? -1 : value.length;
        this.logAsString = logAsString;
    }

    @Override
    public void onCompletion(RecordMetadata metadata, Exception e) {
        if (e != null) {
            String keyString;
            String string = this.key == null ? "null" : (keyString = this.logAsString ? new String(this.key, StandardCharsets.UTF_8) : this.key.length + " bytes");
            String valueString = this.valueLength == -1 ? "null" : (this.logAsString ? new String(this.value, StandardCharsets.UTF_8) : this.valueLength + " bytes");
            log.error("Error when sending message to topic {} with key: {}, value: {} with error:", this.topic, keyString, valueString, e);
        }
    }
}

