/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.logging;

import io.quarkus.bootstrap.graal.ImageInfo;
import io.quarkus.bootstrap.logging.QuarkusDelayedHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.EmbeddedConfigurator;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.handlers.ConsoleHandler;

public final class InitialConfigurator
implements EmbeddedConfigurator {
    public static final QuarkusDelayedHandler DELAYED_HANDLER = new QuarkusDelayedHandler();
    private static final Level MIN_LEVEL;
    private static final String SYS_PROP_NAME = "logging.initial-configurator.min-level";

    @Override
    public Level getMinimumLevelOf(String loggerName) {
        return MIN_LEVEL;
    }

    @Override
    public Level getLevelOf(String loggerName) {
        return loggerName.isEmpty() ? Level.ALL : null;
    }

    @Override
    public Handler[] getHandlersOf(String loggerName) {
        if (loggerName.isEmpty()) {
            if (ImageInfo.inImageBuildtimeCode()) {
                return new Handler[]{InitialConfigurator.createDefaultHandler()};
            }
            return new Handler[]{DELAYED_HANDLER};
        }
        return EmbeddedConfigurator.NO_HANDLERS;
    }

    public static ConsoleHandler createDefaultHandler() {
        ConsoleHandler handler = new ConsoleHandler(new PatternFormatter("%d{HH:mm:ss,SSS} %-5p [%c{3.}] %s%e%n"));
        handler.setLevel(Level.INFO);
        return handler;
    }

    static {
        Level minLevel = Level.ALL;
        String minLevelSysProp = System.getProperty(SYS_PROP_NAME);
        if (minLevelSysProp != null) {
            try {
                minLevel = Level.parse(minLevelSysProp);
            }
            catch (IllegalArgumentException ignored) {
                throw new IllegalArgumentException(String.format("Unable to convert %s (obtained from the %s system property) into a known logging level.", minLevelSysProp, SYS_PROP_NAME));
            }
        }
        MIN_LEVEL = minLevel;
    }
}

