/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.InjectableReferenceProvider;
import jakarta.enterprise.context.spi.CreationalContext;

public class DecoratorDelegateProvider
implements InjectableReferenceProvider<Object> {
    private static final ThreadLocal<Object> CURRENT = new ThreadLocal();

    @Override
    public Object get(CreationalContext<Object> creationalContext) {
        return CURRENT.get();
    }

    public static Object set(Object delegate) {
        if (delegate != null) {
            Object prev = CURRENT.get();
            if (delegate.equals(prev)) {
                return delegate;
            }
            CURRENT.set(delegate);
            return prev;
        }
        CURRENT.remove();
        return null;
    }

    public static void unset() {
        DecoratorDelegateProvider.set(null);
    }

    public static Object get() {
        return CURRENT.get();
    }
}

