/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.UDPRouteRule;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.UDPRouteRuleBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.UDPRouteRuleFluentImpl;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.UDPRouteSpec;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.UDPRouteSpecFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ParentReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ParentReferenceBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ParentReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class UDPRouteSpecFluentImpl<A extends UDPRouteSpecFluent<A>>
extends BaseFluent<A>
implements UDPRouteSpecFluent<A> {
    private ArrayList<ParentReferenceBuilder> parentRefs = new ArrayList();
    private ArrayList<UDPRouteRuleBuilder> rules = new ArrayList();
    private Map<String, Object> additionalProperties;

    public UDPRouteSpecFluentImpl() {
    }

    public UDPRouteSpecFluentImpl(UDPRouteSpec instance) {
        if (instance != null) {
            this.withParentRefs(instance.getParentRefs());
            this.withRules(instance.getRules());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToParentRefs(int index, ParentReference item) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
        if (index < 0 || index >= this.parentRefs.size()) {
            this._visitables.get("parentRefs").add(builder);
            this.parentRefs.add(builder);
        } else {
            this._visitables.get("parentRefs").add(index, builder);
            this.parentRefs.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToParentRefs(int index, ParentReference item) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
        if (index < 0 || index >= this.parentRefs.size()) {
            this._visitables.get("parentRefs").add(builder);
            this.parentRefs.add(builder);
        } else {
            this._visitables.get("parentRefs").set(index, builder);
            this.parentRefs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToParentRefs(ParentReference ... items) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get("parentRefs").add(builder);
            this.parentRefs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToParentRefs(Collection<ParentReference> items) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get("parentRefs").add(builder);
            this.parentRefs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromParentRefs(ParentReference ... items) {
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get("parentRefs").remove(builder);
            if (this.parentRefs == null) continue;
            this.parentRefs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromParentRefs(Collection<ParentReference> items) {
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get("parentRefs").remove(builder);
            if (this.parentRefs == null) continue;
            this.parentRefs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromParentRefs(Predicate<ParentReferenceBuilder> predicate) {
        if (this.parentRefs == null) {
            return (A)this;
        }
        Iterator<ParentReferenceBuilder> each = this.parentRefs.iterator();
        Object visitables = this._visitables.get("parentRefs");
        while (each.hasNext()) {
            ParentReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ParentReference> getParentRefs() {
        return this.parentRefs != null ? UDPRouteSpecFluentImpl.build(this.parentRefs) : null;
    }

    @Override
    public List<ParentReference> buildParentRefs() {
        return this.parentRefs != null ? UDPRouteSpecFluentImpl.build(this.parentRefs) : null;
    }

    @Override
    public ParentReference buildParentRef(int index) {
        return this.parentRefs.get(index).build();
    }

    @Override
    public ParentReference buildFirstParentRef() {
        return this.parentRefs.get(0).build();
    }

    @Override
    public ParentReference buildLastParentRef() {
        return this.parentRefs.get(this.parentRefs.size() - 1).build();
    }

    @Override
    public ParentReference buildMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        for (ParentReferenceBuilder item : this.parentRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        for (ParentReferenceBuilder item : this.parentRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withParentRefs(List<ParentReference> parentRefs) {
        if (this.parentRefs != null) {
            this._visitables.get("parentRefs").clear();
        }
        if (parentRefs != null) {
            this.parentRefs = new ArrayList();
            for (ParentReference item : parentRefs) {
                this.addToParentRefs(item);
            }
        } else {
            this.parentRefs = null;
        }
        return (A)this;
    }

    @Override
    public A withParentRefs(ParentReference ... parentRefs) {
        if (this.parentRefs != null) {
            this.parentRefs.clear();
            this._visitables.remove("parentRefs");
        }
        if (parentRefs != null) {
            for (ParentReference item : parentRefs) {
                this.addToParentRefs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasParentRefs() {
        return this.parentRefs != null && !this.parentRefs.isEmpty();
    }

    @Override
    public UDPRouteSpecFluent.ParentRefsNested<A> addNewParentRef() {
        return new ParentRefsNestedImpl();
    }

    @Override
    public UDPRouteSpecFluent.ParentRefsNested<A> addNewParentRefLike(ParentReference item) {
        return new ParentRefsNestedImpl(-1, item);
    }

    @Override
    public UDPRouteSpecFluent.ParentRefsNested<A> setNewParentRefLike(int index, ParentReference item) {
        return new ParentRefsNestedImpl(index, item);
    }

    @Override
    public UDPRouteSpecFluent.ParentRefsNested<A> editParentRef(int index) {
        if (this.parentRefs.size() <= index) {
            throw new RuntimeException("Can't edit parentRefs. Index exceeds size.");
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    @Override
    public UDPRouteSpecFluent.ParentRefsNested<A> editFirstParentRef() {
        if (this.parentRefs.size() == 0) {
            throw new RuntimeException("Can't edit first parentRefs. The list is empty.");
        }
        return this.setNewParentRefLike(0, this.buildParentRef(0));
    }

    @Override
    public UDPRouteSpecFluent.ParentRefsNested<A> editLastParentRef() {
        int index = this.parentRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last parentRefs. The list is empty.");
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    @Override
    public UDPRouteSpecFluent.ParentRefsNested<A> editMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parentRefs.size(); ++i) {
            if (!predicate.test(this.parentRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching parentRefs. No match found.");
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    @Override
    public A addToRules(int index, UDPRouteRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        UDPRouteRuleBuilder builder = new UDPRouteRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").add(index, builder);
            this.rules.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToRules(int index, UDPRouteRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        UDPRouteRuleBuilder builder = new UDPRouteRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").set(index, builder);
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(UDPRouteRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (UDPRouteRule item : items) {
            UDPRouteRuleBuilder builder = new UDPRouteRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<UDPRouteRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (UDPRouteRule item : items) {
            UDPRouteRuleBuilder builder = new UDPRouteRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(UDPRouteRule ... items) {
        for (UDPRouteRule item : items) {
            UDPRouteRuleBuilder builder = new UDPRouteRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<UDPRouteRule> items) {
        for (UDPRouteRule item : items) {
            UDPRouteRuleBuilder builder = new UDPRouteRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRules(Predicate<UDPRouteRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<UDPRouteRuleBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            UDPRouteRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<UDPRouteRule> getRules() {
        return this.rules != null ? UDPRouteSpecFluentImpl.build(this.rules) : null;
    }

    @Override
    public List<UDPRouteRule> buildRules() {
        return this.rules != null ? UDPRouteSpecFluentImpl.build(this.rules) : null;
    }

    @Override
    public UDPRouteRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    @Override
    public UDPRouteRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public UDPRouteRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public UDPRouteRule buildMatchingRule(Predicate<UDPRouteRuleBuilder> predicate) {
        for (UDPRouteRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRule(Predicate<UDPRouteRuleBuilder> predicate) {
        for (UDPRouteRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRules(List<UDPRouteRule> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").clear();
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (UDPRouteRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    @Override
    public A withRules(UDPRouteRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove("rules");
        }
        if (rules != null) {
            for (UDPRouteRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public UDPRouteSpecFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public UDPRouteSpecFluent.RulesNested<A> addNewRuleLike(UDPRouteRule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public UDPRouteSpecFluent.RulesNested<A> setNewRuleLike(int index, UDPRouteRule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public UDPRouteSpecFluent.RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public UDPRouteSpecFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public UDPRouteSpecFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public UDPRouteSpecFluent.RulesNested<A> editMatchingRule(Predicate<UDPRouteRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UDPRouteSpecFluentImpl that = (UDPRouteSpecFluentImpl)o;
        if (!Objects.equals(this.parentRefs, that.parentRefs)) {
            return false;
        }
        if (!Objects.equals(this.rules, that.rules)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.parentRefs, this.rules, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parentRefs != null) {
            sb.append("parentRefs:");
            sb.append(this.parentRefs + ",");
        }
        if (this.rules != null) {
            sb.append("rules:");
            sb.append(this.rules + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class RulesNestedImpl<N>
    extends UDPRouteRuleFluentImpl<UDPRouteSpecFluent.RulesNested<N>>
    implements UDPRouteSpecFluent.RulesNested<N>,
    Nested<N> {
        UDPRouteRuleBuilder builder;
        int index;

        RulesNestedImpl(int index, UDPRouteRule item) {
            this.index = index;
            this.builder = new UDPRouteRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new UDPRouteRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)UDPRouteSpecFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    class ParentRefsNestedImpl<N>
    extends ParentReferenceFluentImpl<UDPRouteSpecFluent.ParentRefsNested<N>>
    implements UDPRouteSpecFluent.ParentRefsNested<N>,
    Nested<N> {
        ParentReferenceBuilder builder;
        int index;

        ParentRefsNestedImpl(int index, ParentReference item) {
            this.index = index;
            this.builder = new ParentReferenceBuilder(this, item);
        }

        ParentRefsNestedImpl() {
            this.index = -1;
            this.builder = new ParentReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)UDPRouteSpecFluentImpl.this.setToParentRefs(this.index, this.builder.build());
        }

        @Override
        public N endParentRef() {
            return this.and();
        }
    }
}

