/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.streams.impl;

import io.vertx.proton.ProtonSender;
import io.vertx.proton.streams.ProtonSubscriber;
import io.vertx.proton.streams.Tracker;
import io.vertx.proton.streams.impl.ProtonSubscriberImpl;
import java.util.Objects;
import org.apache.qpid.proton.amqp.transport.Source;
import org.apache.qpid.proton.amqp.transport.Target;
import org.apache.qpid.proton.message.Message;
import org.reactivestreams.Subscription;

public class ProtonSubscriberWrapperImpl
implements ProtonSubscriber<Message> {
    private final ProtonSubscriberImpl delegate;

    public ProtonSubscriberWrapperImpl(ProtonSubscriberImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        this.delegate.onSubscribe(subscription);
    }

    @Override
    public void onNext(Message m) {
        Objects.requireNonNull(m, "An element must be supplied when calling onNext");
        Tracker s = Tracker.create(m, null);
        this.delegate.onNext(s);
    }

    @Override
    public void onError(Throwable t) {
        this.delegate.onError(t);
    }

    @Override
    public void onComplete() {
        this.delegate.onComplete();
    }

    public boolean isEmitOnConnectionEnd() {
        return this.delegate.isEmitOnConnectionEnd();
    }

    public void setEmitOnConnectionEnd(boolean emitOnConnectionEnd) {
        this.delegate.setEmitOnConnectionEnd(emitOnConnectionEnd);
    }

    public ProtonSender getLink() {
        return this.delegate.getLink();
    }

    @Override
    public ProtonSubscriber<Message> setSource(Source source) {
        this.delegate.setSource(source);
        return this;
    }

    @Override
    public Source getSource() {
        return this.delegate.getSource();
    }

    @Override
    public ProtonSubscriber<Message> setTarget(Target target) {
        this.delegate.setTarget(target);
        return this;
    }

    @Override
    public Target getTarget() {
        return this.delegate.getTarget();
    }

    public Source getRemoteSource() {
        return this.delegate.getRemoteSource();
    }

    public Target getRemoteTarget() {
        return this.delegate.getRemoteTarget();
    }
}

