/*
 * Decompiled with CFR 0.152.
 */
package com.aayushatharva.brotli4j.encoder;

import com.aayushatharva.brotli4j.encoder.Encoder;
import com.aayushatharva.brotli4j.encoder.PreparedDictionary;
import java.io.IOException;
import java.nio.ByteBuffer;

class EncoderJNI {
    EncoderJNI() {
    }

    private static native ByteBuffer nativeCreate(long[] var0);

    private static native void nativePush(long[] var0, int var1);

    private static native ByteBuffer nativePull(long[] var0);

    private static native void nativeDestroy(long[] var0);

    private static native boolean nativeAttachDictionary(long[] var0, ByteBuffer var1);

    private static native ByteBuffer nativePrepareDictionary(ByteBuffer var0, long var1);

    private static native void nativeDestroyDictionary(ByteBuffer var0);

    static PreparedDictionary prepareDictionary(ByteBuffer dictionary, int sharedDictionaryType) {
        if (!dictionary.isDirect()) {
            throw new IllegalArgumentException("only direct buffers allowed");
        }
        ByteBuffer dictionaryData = EncoderJNI.nativePrepareDictionary(dictionary, sharedDictionaryType);
        if (dictionaryData == null) {
            throw new IllegalStateException("OOM");
        }
        return new PreparedDictionaryImpl(dictionaryData);
    }

    static class Wrapper {
        protected final long[] context = new long[5];
        private final ByteBuffer inputBuffer;
        private boolean fresh = true;

        Wrapper(int inputBufferSize, int quality, int lgwin, Encoder.Mode mode) throws IOException {
            if (inputBufferSize <= 0) {
                throw new IOException("buffer size must be positive");
            }
            this.context[1] = inputBufferSize;
            this.context[2] = quality;
            this.context[3] = lgwin;
            this.context[4] = mode != null ? (long)mode.ordinal() : -1L;
            this.inputBuffer = EncoderJNI.nativeCreate(this.context);
            if (this.context[0] == 0L) {
                throw new IOException("failed to initialize native brotli encoder");
            }
            this.context[1] = 1L;
            this.context[2] = 0L;
            this.context[3] = 0L;
            this.context[4] = 0L;
        }

        boolean attachDictionary(ByteBuffer dictionary) {
            if (!dictionary.isDirect()) {
                throw new IllegalArgumentException("only direct buffers allowed");
            }
            if (this.context[0] == 0L) {
                throw new IllegalStateException("brotli decoder is already destroyed");
            }
            if (!this.fresh) {
                throw new IllegalStateException("decoding is already started");
            }
            return EncoderJNI.nativeAttachDictionary(this.context, dictionary);
        }

        void push(Operation op, int length) {
            if (length < 0) {
                throw new IllegalArgumentException("negative block length");
            }
            if (this.context[0] == 0L) {
                throw new IllegalStateException("brotli encoder is already destroyed");
            }
            if (!this.isSuccess() || this.hasMoreOutput()) {
                throw new IllegalStateException("pushing input to encoder in unexpected state");
            }
            if (this.hasRemainingInput() && length != 0) {
                throw new IllegalStateException("pushing input to encoder over previous input");
            }
            this.context[1] = op.ordinal();
            this.fresh = false;
            EncoderJNI.nativePush(this.context, length);
        }

        boolean isSuccess() {
            return this.context[1] != 0L;
        }

        boolean hasMoreOutput() {
            return this.context[2] != 0L;
        }

        boolean hasRemainingInput() {
            return this.context[3] != 0L;
        }

        boolean isFinished() {
            return this.context[4] != 0L;
        }

        ByteBuffer getInputBuffer() {
            return this.inputBuffer;
        }

        ByteBuffer pull() {
            if (this.context[0] == 0L) {
                throw new IllegalStateException("brotli encoder is already destroyed");
            }
            if (!this.isSuccess() || !this.hasMoreOutput()) {
                throw new IllegalStateException("pulling while data is not ready");
            }
            this.fresh = false;
            return EncoderJNI.nativePull(this.context);
        }

        void destroy() {
            if (this.context[0] == 0L) {
                throw new IllegalStateException("brotli encoder is already destroyed");
            }
            EncoderJNI.nativeDestroy(this.context);
            this.context[0] = 0L;
        }

        protected void finalize() throws Throwable {
            if (this.context[0] != 0L) {
                this.destroy();
            }
            super.finalize();
        }
    }

    private static class PreparedDictionaryImpl
    implements PreparedDictionary {
        private ByteBuffer data;

        private PreparedDictionaryImpl(ByteBuffer data) {
            this.data = data;
        }

        @Override
        public ByteBuffer getData() {
            return this.data;
        }

        protected void finalize() throws Throwable {
            try {
                ByteBuffer data = this.data;
                this.data = null;
                EncoderJNI.nativeDestroyDictionary(data);
            }
            finally {
                super.finalize();
            }
        }
    }

    static enum Operation {
        PROCESS,
        FLUSH,
        FINISH;

    }
}

