/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WeakRefList {
    private List<WeakReference<?>> userObjects;

    public WeakRefList(int initialSize) {
        this.userObjects = new ArrayList(initialSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getSafeCopy() {
        Object[] result;
        int pos = 0;
        List<WeakReference<?>> list = this.userObjects;
        synchronized (list) {
            result = new Object[this.userObjects.size()];
            Iterator<WeakReference<?>> i = this.userObjects.iterator();
            while (i.hasNext()) {
                WeakReference<?> ref = i.next();
                Object userObject = ref.get();
                if (userObject == null) {
                    i.remove();
                    continue;
                }
                result[pos] = userObject;
                ++pos;
            }
        }
        if (pos == result.length) {
            return result;
        }
        Object[] tmp = new Object[pos];
        System.arraycopy(result, 0, tmp, 0, pos);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object object) {
        WeakReference<Object> ref = new WeakReference<Object>(object);
        List<WeakReference<?>> list = this.userObjects;
        synchronized (list) {
            this.userObjects.add(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(Object object) {
        List<WeakReference<?>> list = this.userObjects;
        synchronized (list) {
            Iterator<WeakReference<?>> i = this.userObjects.iterator();
            while (true) {
                if (!i.hasNext()) {
                    return false;
                }
                WeakReference<?> ref = i.next();
                Object userObject = ref.get();
                if (userObject == null) {
                    i.remove();
                    continue;
                }
                if (userObject == object) break;
            }
            i.remove();
            return true;
        }
    }
}

