/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.index;

import java.util.Date;
import java.util.List;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.m2e.core.embedder.ArtifactKey;

public class IndexedArtifactFile
implements IAdaptable {
    public final String repository;
    public final String group;
    public final String artifact;
    public final String fname;
    public final String version;
    private ArtifactVersion artifactVersion;
    public final String type;
    public final String classifier;
    public final long size;
    public final Date date;
    public final int sourcesExists;
    public final int javadocExists;
    public final String prefix;
    public final List<String> goals;

    public IndexedArtifactFile(String repository, String group, String artifact, String version, String type, String classifier, String fname, long size, Date date, int sourcesExists, int javadocExists, String prefix, List<String> goals) {
        this.repository = repository;
        this.group = group;
        this.artifact = artifact;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
        this.fname = fname;
        this.size = size;
        this.date = date == null ? null : new Date(date.getTime());
        this.sourcesExists = sourcesExists;
        this.javadocExists = javadocExists;
        this.prefix = prefix;
        this.goals = goals;
    }

    public ArtifactVersion getArtifactVersion() {
        if (this.artifactVersion == null) {
            this.artifactVersion = new DefaultArtifactVersion(this.version);
        }
        return this.artifactVersion;
    }

    public Dependency getDependency() {
        Dependency dependency = new Dependency();
        dependency.setArtifactId(this.artifact);
        dependency.setGroupId(this.group);
        dependency.setVersion(this.version);
        dependency.setClassifier(this.classifier);
        dependency.setType(this.type);
        return dependency;
    }

    public ArtifactKey getArtifactKey() {
        return new ArtifactKey(this.group, this.artifact, this.version, this.classifier);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ArtifactKey.class) {
            return this.getArtifactKey();
        }
        return null;
    }
}

