/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.services.resources.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fx.core.URI;
import org.eclipse.fx.ui.services.resources.GraphicNodeProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Component;

@Component
public class FXMLGraphicsNodeProvider
implements GraphicNodeProvider {
    @Override
    public String getName() {
        return "fx.fxml-graphic-provider";
    }

    @Override
    public List<String> getFileSuffix() {
        return Arrays.asList("fxml");
    }

    @Override
    public Node getGraphicNode(URI uri) throws IOException {
        if (uri.isPlatformPlugin()) {
            Bundle b = Platform.getBundle((String)uri.segment(1));
            if (b != null) {
                StringBuilder sb = new StringBuilder();
                int i = 2;
                while (i < uri.segmentCount()) {
                    if (sb.length() != 0) {
                        sb.append("/");
                    }
                    sb.append(uri.segment(i));
                    ++i;
                }
                FXMLLoader loader = new FXMLLoader();
                loader.setClassLoader(((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader());
                URL url = b.getResource(sb.toString());
                loader.setLocation(url);
                return (Node)loader.load();
            }
            throw new IOException("Unknown bundle '" + uri.segment(1) + "'");
        }
        return (Node)FXMLLoader.load((URL)new URL(uri.toString()));
    }
}

