/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CodeGenUtil2 {
    private static Set<String> javaDefaultTypes;

    public static boolean isJavaLangType(String s) {
        return CodeGenUtil2.getJavaDefaultTypes().contains(s) && Character.isUpperCase(s.charAt(0));
    }

    public static boolean isJavaDefaultType(String s) {
        return CodeGenUtil2.getJavaDefaultTypes().contains(s);
    }

    public static String format(String name, char separator, String prefix, boolean includePrefix, boolean includeLeadingSeparator) {
        String leadingSeparators;
        String string = leadingSeparators = includeLeadingSeparator ? CodeGenUtil2.getLeadingSeparators(name, '_') : null;
        if (leadingSeparators != null) {
            name = name.substring(leadingSeparators.length());
        }
        List<String> parsedName = new ArrayList<String>();
        if (prefix != null && name.startsWith(prefix) && name.length() > prefix.length() && Character.isUpperCase(name.charAt(prefix.length()))) {
            name = name.substring(prefix.length());
            if (includePrefix) {
                parsedName = CodeGenUtil2.parseName(prefix, '_');
            }
        }
        if (name.length() != 0) {
            parsedName.addAll(CodeGenUtil2.parseName(name, '_'));
        }
        StringBuilder result = new StringBuilder();
        Iterator nameIter = parsedName.iterator();
        while (nameIter.hasNext()) {
            String nameComponent = (String)nameIter.next();
            result.append(nameComponent);
            if (!nameIter.hasNext() || nameComponent.length() <= 1) continue;
            result.append(separator);
        }
        if (result.length() == 0 && prefix != null) {
            result.append(prefix);
        }
        return leadingSeparators != null ? "_" + result.toString() : result.toString();
    }

    private static String getLeadingSeparators(String name, char separator) {
        int i = 0;
        int len = name.length();
        while (i < len && name.charAt(i) == separator) {
            ++i;
        }
        return i != 0 ? name.substring(0, i) : null;
    }

    public static List<String> parseName(String sourceName, char separator) {
        ArrayList<String> result = new ArrayList<String>();
        if (sourceName != null) {
            StringBuilder currentWord = new StringBuilder();
            boolean lastIsLower = false;
            int index = 0;
            int length = sourceName.length();
            while (index < length) {
                char curChar = sourceName.charAt(index);
                if (Character.isUpperCase(curChar) || !lastIsLower && Character.isDigit(curChar) || curChar == separator) {
                    if (lastIsLower && currentWord.length() > 1 || curChar == separator && currentWord.length() > 0) {
                        result.add(currentWord.toString());
                        currentWord = new StringBuilder();
                    }
                    lastIsLower = false;
                } else {
                    int currentWordLength;
                    if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                        char lastChar = currentWord.charAt(--currentWordLength);
                        currentWord.setLength(currentWordLength);
                        result.add(currentWord.toString());
                        currentWord = new StringBuilder();
                        currentWord.append(lastChar);
                    }
                    lastIsLower = true;
                }
                if (curChar != separator) {
                    currentWord.append(curChar);
                }
                ++index;
            }
            result.add(currentWord.toString());
        }
        return result;
    }

    public static Set<String> getJavaDefaultTypes() {
        if (javaDefaultTypes == null) {
            HashSet<String> result = new HashSet<String>(100);
            result.add("AbstractMethodError");
            result.add("ArithmeticException");
            result.add("ArrayIndexOutOfBoundsException");
            result.add("ArrayStoreException");
            result.add("Boolean");
            result.add("Byte");
            result.add("Character");
            result.add("Class");
            result.add("ClassCastException");
            result.add("ClassCircularityError");
            result.add("ClassFormatError");
            result.add("ClassLoader");
            result.add("ClassNotFoundException");
            result.add("CloneNotSupportedException");
            result.add("Cloneable");
            result.add("Comparable");
            result.add("Compiler");
            result.add("Double");
            result.add("Deprecated");
            result.add("Enum");
            result.add("Error");
            result.add("Exception");
            result.add("ExceptionInInitializerError");
            result.add("Float");
            result.add("FloatingDecimal");
            result.add("IllegalAccessError");
            result.add("IllegalAccessException");
            result.add("IllegalArgumentException");
            result.add("IllegalMonitorStateException");
            result.add("IllegalStateException");
            result.add("IllegalThreadStateException");
            result.add("IncompatibleClassChangeError");
            result.add("IndexOutOfBoundsException");
            result.add("InheritableThreadLocal");
            result.add("InstantiationError");
            result.add("InstantiationException");
            result.add("Integer");
            result.add("InternalError");
            result.add("InterruptedException");
            result.add("LinkageError");
            result.add("Long");
            result.add("Math");
            result.add("NegativeArraySizeException");
            result.add("NoClassDefFoundError");
            result.add("NoSuchFieldError");
            result.add("NoSuchFieldException");
            result.add("NoSuchMethodError");
            result.add("NoSuchMethodException");
            result.add("NullPointerException");
            result.add("Number");
            result.add("NumberFormatException");
            result.add("Object");
            result.add("Override");
            result.add("OutOfMemoryError");
            result.add("Package");
            result.add("Process");
            result.add("Runnable");
            result.add("Runtime");
            result.add("RuntimeException");
            result.add("RuntimePermission");
            result.add("SecurityException");
            result.add("SecurityManager");
            result.add("Short");
            result.add("StackOverflowError");
            result.add("String");
            result.add("StringBuffer");
            result.add("StringBuilder");
            result.add("StringIndexOutOfBoundsException");
            result.add("SuppressWarnings");
            result.add("System");
            result.add("Thread");
            result.add("ThreadDeath");
            result.add("ThreadGroup");
            result.add("ThreadLocal");
            result.add("Throwable");
            result.add("UnknownError");
            result.add("UnsatisfiedLinkError");
            result.add("UnsupportedClassVersionError");
            result.add("UnsupportedOperationException");
            result.add("VerifyError");
            result.add("VirtualMachineError");
            result.add("Void");
            result.add("boolean");
            result.add("byte");
            result.add("char");
            result.add("double");
            result.add("float");
            result.add("int");
            result.add("long");
            result.add("short");
            javaDefaultTypes = Collections.unmodifiableSet(result);
        }
        return javaDefaultTypes;
    }
}

