/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext;

import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.shape.Line;
import javafx.scene.text.TextFlow;
import javafx.util.Duration;
import org.eclipse.fx.ui.controls.styledtext.StyledTextNode;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StyledTextLayoutContainer
extends Region {
    private final @NonNull ObservableList<@NonNull StyledTextNode> textNodes = FXCollections.observableArrayList();
    private final @NonNull IntegerProperty startOffset = new SimpleIntegerProperty((Object)this, "startOffset");
    private final @NonNull ObjectProperty<@NonNull TextSelection> selection = new SimpleObjectProperty((Object)this, "selection", (Object)TextSelection.EMPTY);
    private final Region selectionMarker = new Region();
    final Line caret = new Line();
    private final TextFlow textLayoutNode = new TextFlow();
    private StyledTextNode selectionStartNode;
    private StyledTextNode selectionEndNode;
    private double selectionStartX;
    private double selectionEndX;
    private Timeline flashTimeline;
    int caretIndex = -1;

    public final IntegerProperty startOffsetProperty() {
        return this.startOffset;
    }

    public final int getStartOffset() {
        return this.startOffsetProperty().get();
    }

    public final void setStartOffset(int startOffset) {
        this.startOffsetProperty().set(startOffset);
    }

    public final ObjectProperty<@NonNull TextSelection> selectionProperty() {
        return this.selection;
    }

    public final @NonNull TextSelection getSelection() {
        return (TextSelection)this.selectionProperty().get();
    }

    public final void setSelection(@NonNull TextSelection selection) {
        this.selectionProperty().set((Object)selection);
    }

    public StyledTextLayoutContainer() {
        this.getStyleClass().add((Object)"styled-text-layout-container");
        this.textNodes.addListener(this::recalculateOffset);
        this.selectionMarker.setVisible(false);
        this.selectionMarker.setManaged(false);
        this.selectionMarker.getStyleClass().add((Object)"selection-marker");
        this.caret.setVisible(false);
        this.caret.setStrokeWidth(2.0);
        this.caret.setManaged(false);
        this.caret.getStyleClass().add((Object)"text-caret");
        this.flashTimeline = new Timeline();
        this.flashTimeline.setCycleCount(-1);
        EventHandler<ActionEvent> startEvent = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                StyledTextLayoutContainer.this.caret.setVisible(StyledTextLayoutContainer.this.caretIndex != -1);
            }
        };
        EventHandler<ActionEvent> endEvent = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                StyledTextLayoutContainer.this.caret.setVisible(false);
            }
        };
        this.flashTimeline.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, (EventHandler)startEvent, new KeyValue[0]), new KeyFrame(Duration.millis((double)500.0), (EventHandler)endEvent, new KeyValue[0]), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[0])});
        Bindings.bindContent((List)this.textLayoutNode.getChildren(), this.textNodes);
        this.getChildren().setAll((Object[])new Node[]{this.selectionMarker, this.textLayoutNode, this.caret});
        this.selectionProperty().addListener(this::handleSelectionChange);
    }

    private int getEndOffset() {
        return this.getStartOffset() + this.getText().length();
    }

    public boolean intersectOffset(int start, int end) {
        if (this.getStartOffset() > end) {
            return false;
        }
        return this.getEndOffset() >= start;
    }

    private void recalculateOffset(Observable o) {
        int offset = 0;
        for (StyledTextNode t : this.textNodes) {
            t.setStartOffset(offset);
            offset = t.getEndOffset();
        }
    }

    private void handleSelectionChange(Observable o, TextSelection oldSelection, TextSelection newSelection) {
        if (newSelection.length == 0) {
            this.selectionMarker.setVisible(false);
            this.selectionMarker.resize(0.0, 0.0);
        } else {
            this.selectionMarker.setVisible(true);
            int start = newSelection.offset;
            int end = newSelection.offset + newSelection.length;
            this.selectionStartNode = null;
            this.selectionEndNode = null;
            for (StyledTextNode t : this.textNodes) {
                if (!t.intersectOffset(start, end)) continue;
                if (this.selectionStartNode == null) {
                    this.selectionStartNode = t;
                }
                this.selectionEndNode = t;
            }
            if (this.selectionStartNode != null && this.selectionEndNode != null) {
                int charIndex = start - this.selectionStartNode.getStartOffset();
                this.selectionStartX = this.selectionStartNode.getCharLocation(charIndex);
                charIndex = end - this.selectionEndNode.getStartOffset();
                this.selectionEndX = this.selectionEndNode.getCharLocation(charIndex);
                this.requestLayout();
            }
        }
    }

    protected double computePrefHeight(double width) {
        double d = super.computePrefHeight(width);
        return d;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.textLayoutNode.relocate(this.getInsets().getLeft(), this.getInsets().getTop());
        if (this.selectionStartNode != null && this.selectionEndNode != null) {
            double x1 = this.textLayoutNode.localToParent(this.selectionStartNode.getBoundsInParent().getMinX(), 0.0).getX() + this.selectionStartX;
            double x2 = this.textLayoutNode.localToParent(this.selectionEndNode.getBoundsInParent().getMinX(), 0.0).getX() + this.selectionEndX;
            this.selectionMarker.resizeRelocate(x1, 0.0, x2 - x1, this.getHeight());
        }
        if (this.caretIndex >= 0) {
            this.textLayoutNode.layout();
            this.textLayoutNode.applyCss();
            for (StyledTextNode t : this.textNodes) {
                t.applyCss();
                if (t.getStartOffset() > this.caretIndex || t.getEndOffset() <= this.caretIndex && this.textNodes.get(this.textNodes.size() - 1) != t) continue;
                double caretX = t.getCharLocation(this.caretIndex - t.getStartOffset());
                double x = this.textLayoutNode.localToParent(t.getBoundsInParent().getMinX(), 0.0).getX() + caretX;
                double h = t.prefHeight(-1.0);
                this.caret.setStartX(x);
                this.caret.setEndX(x);
                this.caret.setStartY(this.getInsets().getTop() + 1.0);
                this.caret.setEndY(h + this.getInsets().getTop() + 1.0);
                this.caret.toFront();
                return;
            }
            this.caret.setStartX(0.0);
            this.caret.setEndX(0.0);
            this.caret.setStartY(0.0);
            this.caret.setEndY(15.0);
        } else {
            this.caret.setStartX(0.0);
            this.caret.setEndX(0.0);
            this.caret.setStartY(0.0);
            this.caret.setEndY(this.getHeight());
        }
    }

    public @NonNull ObservableList<@NonNull StyledTextNode> getTextNodes() {
        return this.textNodes;
    }

    public int getCaretIndexAtPoint(Point2D point) {
        Point2D scenePoint = this.localToScene(point);
        for (StyledTextNode t : this.textNodes) {
            if (!t.localToScene(t.getBoundsInLocal()).contains(scenePoint)) continue;
            return t.getCaretIndexAtPoint(t.sceneToLocal(scenePoint)) + t.getStartOffset();
        }
        return -1;
    }

    private String getText() {
        StringBuilder b = new StringBuilder();
        for (StyledTextNode t : this.textNodes) {
            b.append(t.getText());
        }
        return b.toString();
    }

    public void setCaretIndex(int index) {
        if (index >= 0) {
            this.caretIndex = index;
            this.caret.setVisible(true);
            this.flashTimeline.play();
            this.requestLayout();
        } else {
            this.caretIndex = -1;
            this.flashTimeline.stop();
            this.caret.setVisible(false);
            this.requestLayout();
        }
    }

    public @Nullable Point2D getCareLocation(int index) {
        for (StyledTextNode t : this.textNodes) {
            if (t.getStartOffset() > index || t.getEndOffset() < index) continue;
            double x = t.getCharLocation(index);
            return this.sceneToLocal(t.localToScene(x, 0.0));
        }
        return null;
    }
}

