/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.context;

import java.io.File;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletRequestBuilder;

public class ProxyContext {
    private static final String JAVAX_SERVLET_CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    private String servletPath;
    private HashMap<ContextController, ContextAttributes> attributesMap = new HashMap();
    File proxyContextTempDir;
    private ServletContext servletContext;

    public ProxyContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        File tempDir = (File)servletContext.getAttribute(JAVAX_SERVLET_CONTEXT_TEMPDIR);
        if (tempDir != null) {
            this.proxyContextTempDir = new File(tempDir, "proxytemp");
            ProxyContext.deleteDirectory(this.proxyContextTempDir);
            this.proxyContextTempDir.mkdirs();
        }
    }

    public void destroy() {
        if (this.proxyContextTempDir != null) {
            ProxyContext.deleteDirectory(this.proxyContextTempDir);
        }
    }

    synchronized void initializeServletPath(HttpServletRequest req) {
        if (this.servletPath == null) {
            this.servletPath = HttpServletRequestBuilder.getDispatchServletPath(req);
        }
    }

    public synchronized String getServletPath() {
        return this.servletPath == null ? "" : this.servletPath;
    }

    public synchronized void createContextAttributes(ContextController controller) {
        ContextAttributes attributes = this.attributesMap.get(controller);
        if (attributes == null) {
            attributes = new ContextAttributes(controller);
            this.attributesMap.put(controller, attributes);
        }
        attributes.addReference();
    }

    public synchronized void destroyContextAttributes(ContextController controller) {
        ContextAttributes attributes = this.attributesMap.get(controller);
        if (attributes == null) {
            throw new IllegalStateException("too many calls");
        }
        attributes.removeReference();
        if (attributes.referenceCount() == 0) {
            this.attributesMap.remove(controller);
            attributes.destroy();
        }
    }

    public synchronized Dictionary<String, Object> getContextAttributes(ContextController controller) {
        return this.attributesMap.get(controller);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    protected static boolean deleteDirectory(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    ProxyContext.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return directory.delete();
    }

    public class ContextAttributes
    extends Hashtable<String, Object> {
        private static final long serialVersionUID = 1916670423277243587L;
        private int referenceCount;

        public ContextAttributes(ContextController controller) {
            if (ProxyContext.this.proxyContextTempDir != null) {
                File contextTempDir = new File(ProxyContext.this.proxyContextTempDir, "hc_" + controller.hashCode());
                contextTempDir.mkdirs();
                this.put(ProxyContext.JAVAX_SERVLET_CONTEXT_TEMPDIR, contextTempDir);
            }
        }

        public void destroy() {
            File contextTempDir = (File)this.get(ProxyContext.JAVAX_SERVLET_CONTEXT_TEMPDIR);
            if (contextTempDir != null) {
                ProxyContext.deleteDirectory(contextTempDir);
            }
        }

        public void addReference() {
            ++this.referenceCount;
        }

        public void removeReference() {
            --this.referenceCount;
        }

        public int referenceCount() {
            return this.referenceCount;
        }
    }
}

