/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.widget;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.input.DragEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDFeedbackService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.SplitDnDSupport;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WWidgetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class WLayoutedWidgetImpl<N, NN extends Node, M extends MUIElement>
extends WWidgetImpl<N, M>
implements WLayoutedWidget<M> {
    private Node staticLayoutGroup;
    private double weight = 10.0;
    private WCallback<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull WDragTargetWidget.DropData, @Nullable Void> dropCallback;
    @Inject
    @NonNull DnDFeedbackService feedbackService;
    @Inject
    @NonNull EModelService modelService;
    @Inject
    @Log
    protected @NonNull Logger logger;

    protected abstract NN getWidgetNode();

    public @NonNull Node getStaticLayoutNode() {
        Node staticLayoutGroup = this.staticLayoutGroup;
        if (staticLayoutGroup == null) {
            this.staticLayoutGroup = staticLayoutGroup = this.createStaticLayoutNode();
        }
        return staticLayoutGroup;
    }

    protected @NonNull Node createStaticLayoutNode() {
        Pane staticLayoutGroup = this.createStaticPane();
        this.initDnd(staticLayoutGroup);
        NN n = this.getWidgetNode();
        if (n != null) {
            staticLayoutGroup.getChildren().add(n);
        } else {
            this.logger.error("No widget node to attach");
        }
        return staticLayoutGroup;
    }

    protected void initDnd(Pane staticLayoutGroup) {
        SplitDnDSupport dndSupport = new SplitDnDSupport(this.modelService, this.feedbackService, this);
        staticLayoutGroup.addEventHandler(DragEvent.DRAG_OVER, dndSupport::handleDragOver);
        staticLayoutGroup.addEventHandler(DragEvent.DRAG_EXITED, dndSupport::handleDragExit);
        staticLayoutGroup.addEventHandler(DragEvent.DRAG_DROPPED, dndSupport::handleDragDropped);
    }

    public final void setDragDroppedCallback(@Nullable WCallback<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull WDragTargetWidget.DropData, @Nullable Void> callback) {
        this.dropCallback = callback;
    }

    public @Nullable WCallback<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull WDragTargetWidget.DropData, @Nullable Void> getDropDroppedCallback() {
        return this.dropCallback;
    }

    protected @NonNull Pane createStaticPane() {
        return new StackPane();
    }

    public void addStyleClasses(List<String> classnames) {
        this.getWidgetNode().getStyleClass().addAll(classnames);
        this.getWidgetNode().applyCss();
    }

    public void addStyleClasses(String ... classnames) {
        this.getWidgetNode().getStyleClass().addAll((Object[])classnames);
        this.getWidgetNode().applyCss();
    }

    public void removeStyleClasses(List<String> classnames) {
        this.getWidgetNode().getStyleClass().removeAll(classnames);
        this.getWidgetNode().applyCss();
    }

    public void removeStyleClasses(String ... classnames) {
        this.getWidgetNode().getStyleClass().removeAll((Object[])classnames);
        this.getWidgetNode().applyCss();
    }

    public void setStyleId(String id) {
        this.getWidgetNode().setId(id);
        this.getWidgetNode().applyCss();
    }

    @Override
    protected void setUserData(WWidgetImpl<N, M> widget) {
        this.getWidgetNode().setUserData(widget);
    }

    public double getWeight() {
        return this.weight;
    }

    @Inject
    void setContainerData(@Named(value="containerData") @Optional String data) {
        if (data != null && !data.isEmpty()) {
            try {
                this.weight = Double.parseDouble(data);
                return;
            }
            catch (Throwable t) {
                this.logger.error(t.getMessage(), t);
            }
        }
        this.weight = 10.0;
    }
}

