/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx;

import java.util.HashMap;
import java.util.Map;
import javafx.application.Application;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.lifecycle.PreSave;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.fx.core.databinding.JFXRealm;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.osgi.util.AbstractJFXApplication;
import org.eclipse.fx.osgi.util.LoggerCreator;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.services.sync.UISynchronize;
import org.eclipse.fx.ui.services.theme.Theme;
import org.eclipse.fx.ui.services.theme.ThemeManager;
import org.eclipse.fx.ui.workbench.base.AbstractE4Application;
import org.eclipse.fx.ui.workbench.fx.DefaultJFXApp;
import org.eclipse.fx.ui.workbench.fx.EMFUri;
import org.eclipse.fx.ui.workbench.fx.internal.GraphicsLoaderImpl;
import org.eclipse.fx.ui.workbench.fx.internal.UISynchronizeImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.prefs.BackingStoreException;

public class E4Application
extends AbstractE4Application {
    static Logger LOGGER = LoggerCreator.createLogger(E4Application.class);
    E4Workbench workbench;
    Location instanceLocation;
    IEclipseContext workbenchContext;
    private static final String EXIT_CODE = "e4.osgi.exit.code";
    private static final String PRIMARY_STAGE_KEY = "primaryStage";
    private static final String CREATE_WORKBENCH_ON_NON_UI_THREAD_ARG = "createWorkbenchOnNonUIThread";
    static E4Application SELF;
    IApplicationContext applicationContext;
    Object returnValue;
    protected EventAdmin eventAdmin;

    public static @NonNull E4Application getE4Application() {
        E4Application self = SELF;
        if (self == null) {
            throw new IllegalStateException("Application not yet initialized");
        }
        return self;
    }

    public Object start(IApplicationContext context) throws Exception {
        SELF = this;
        this.applicationContext = context;
        this.applicationContext.applicationRunning();
        Bundle b = FrameworkUtil.getBundle(AbstractJFXApplication.class);
        BundleContext bundleContext = b.getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(EventAdmin.class);
        if (ref != null) {
            this.eventAdmin = (EventAdmin)bundleContext.getService(ref);
        }
        this.launchE4JavaFxApplication();
        try {
            Object object = this.returnValue == null ? IApplication.EXIT_OK : this.returnValue;
            return object;
        }
        finally {
            this.returnValue = null;
        }
    }

    public void jfxStart(final IApplicationContext context, final Application jfxApplication, final Stage primaryStage) {
        Runnable startRunnable = new Runnable(){

            @Override
            public void run() {
                if (E4Application.this.workbench == null && !E4Application.this.initE4Workbench(context, jfxApplication, primaryStage)) {
                    return;
                }
                final E4Workbench workbench = E4Application.this.workbench;
                if (workbench == null) {
                    throw new IllegalStateException("Not workbench instance yet available");
                }
                final IEclipseContext wbContext = workbench.getContext();
                if (wbContext == null) {
                    throw new IllegalStateException("The workbench has no context assigned");
                }
                UISynchronize uiSync = (UISynchronize)workbench.getContext().get(UISynchronize.class);
                uiSync.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).E4Application.this.instanceLocation = (Location)wbContext.get("instanceLocation");
                        try {
                            if (!E4Application.this.checkInstanceLocation((this).E4Application.this.instanceLocation, wbContext)) {
                                return;
                            }
                            (this).E4Application.this.workbenchContext = (this).E4Application.this.workbench.getContext();
                            workbench.createAndRunUI((MApplicationElement)(this).E4Application.this.workbench.getApplication());
                        }
                        finally {
                            E4Application.this.postJfxStarted(context);
                        }
                    }
                });
            }
        };
        if (E4Application.getArgValue((String)CREATE_WORKBENCH_ON_NON_UI_THREAD_ARG, (IApplicationContext)context, (boolean)true) != null) {
            Thread t = new Thread(startRunnable);
            t.start();
        } else {
            startRunnable.run();
        }
    }

    protected void preLifecycle(IEclipseContext appContext) {
        super.preLifecycle(appContext);
        appContext.set(GraphicsLoader.class, (Object)((GraphicsLoader)ContextInjectionFactory.make(GraphicsLoaderImpl.class, (IEclipseContext)appContext)));
    }

    public void jfxStop() {
        Object returnCode;
        block10: {
            returnCode = null;
            try {
                ThemeManager manager;
                Theme theme;
                if (this.workbenchContext == null || this.workbench == null) break block10;
                returnCode = this.workbenchContext.get(EXIT_CODE);
                if (returnCode == null && this.workbench.isRestart()) {
                    returnCode = IApplication.EXIT_RESTART;
                }
                if (this.getLifecycleManager() != null) {
                    ContextInjectionFactory.invoke((Object)this.getLifecycleManager(), PreSave.class, (IEclipseContext)this.workbenchContext, null);
                }
                if ((theme = (manager = (ThemeManager)this.workbenchContext.get(ThemeManager.class)).getCurrentTheme()) != null) {
                    IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.fx.ui.workbench.fx");
                    node.put("cssTheme", theme.getId());
                    try {
                        node.flush();
                    }
                    catch (BackingStoreException e) {
                        LOGGER.error("Failed to remember the theme id", (Throwable)e);
                    }
                }
                this.saveModel();
                this.workbench.close();
            }
            finally {
                if (this.instanceLocation != null) {
                    this.instanceLocation.release();
                }
            }
        }
        if (returnCode != null) {
            this.returnValue = returnCode;
        }
    }

    public void stop() {
    }

    public boolean initE4Workbench(IApplicationContext context, Application jfxApplication, Stage primaryStage) {
        IEclipseContext workbenchContext = this.createApplicationContext();
        workbenchContext.set(Application.class, (Object)jfxApplication);
        workbenchContext.set(PRIMARY_STAGE_KEY, (Object)primaryStage);
        this.workbench = this.createE4Workbench(context, workbenchContext);
        return this.workbench != null;
    }

    public IApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected void launchE4JavaFxApplication() throws Exception {
        Application.launch(this.getJfxApplicationClass(), (String[])new String[0]);
    }

    protected Class<? extends Application> getJfxApplicationClass() {
        return DefaultJFXApp.class;
    }

    protected void postJfxStarted(IApplicationContext context) {
        context.applicationRunning();
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.sendEvent("org/eclipse/fx/E4Application/Launched", map);
    }

    protected UISynchronize createSynchronizer(IEclipseContext appContext) {
        return (UISynchronize)ContextInjectionFactory.make(UISynchronizeImpl.class, (IEclipseContext)appContext);
    }

    protected Realm createRealm(IEclipseContext appContext) {
        return JFXRealm.createDefault();
    }

    protected IResourceUtilities<Image> createResourceUtility(final IEclipseContext appContext) {
        return new IResourceUtilities<Image>(){

            public Image imageDescriptorFromURI(URI iconPath) {
                if (iconPath == null) {
                    return null;
                }
                GraphicsLoader l = (GraphicsLoader)appContext.get(GraphicsLoader.class);
                return l.getImage((org.eclipse.fx.core.URI)new EMFUri(iconPath));
            }
        };
    }

    protected String getDefaultPresentationEngineURI(IEclipseContext appContext) {
        return "bundleclass://org.eclipse.fx.ui.workbench.fx/org.eclipse.fx.ui.workbench.fx.PartRenderingEngine";
    }

    protected void sendEvent(String topic, Map<String, Object> map) {
        if (this.eventAdmin != null) {
            this.eventAdmin.sendEvent(new Event(topic, map));
        } else {
            LOGGER.warningf("Could not send the %s event. EventAdmin is missing.", new Object[]{topic});
        }
    }
}

