/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.datasource;

import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.eclipse.ebpm.datasource.IDataSourceManager;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceManager
implements IDataSourceManager {
    private EventAdmin ea = null;
    private static Logger logger = LoggerFactory.getLogger(DataSourceManager.class);
    private ConcurrentHashMap<String, ServiceReference> datasources = new ConcurrentHashMap();
    private ComponentContext componentContext = null;

    protected void activate(ComponentContext componentContext) {
        logger.info(" DataSourceManager - ACTIVATED");
        this.componentContext = componentContext;
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info(" DataSourceManager - DEACTIVATED");
    }

    public void addDataSource(ServiceReference dataSourceServiceReference) {
        String dsIdentifier = (String)dataSourceServiceReference.getProperty("id");
        logger.info(" DataSource [" + dsIdentifier + "] -- REGISTERED");
        this.datasources.put(dsIdentifier, dataSourceServiceReference);
        this.notify(dsIdentifier, "_INTERNAL_EVENT_DS_DEPLOYED");
    }

    public void removeDataSource(ServiceReference dataSourceServiceReference) {
        String dsIdentifier = (String)dataSourceServiceReference.getProperty("id");
        logger.info(" DataSource [" + dsIdentifier + "] -- UNREGISTERED");
        this.datasources.remove(dsIdentifier);
        this.notify(dsIdentifier, "_INTERNAL_EVENT_DS_UNDEPLOYED");
    }

    @Override
    public DataSource getDataSource(String datasourceIdentifier) throws Exception {
        ServiceReference sr = this.datasources.get(datasourceIdentifier);
        if (sr == null) {
            logger.error("DataSourceManager -> No datasource registered with id [" + datasourceIdentifier + "]");
            throw new Exception("DataSourceManager -> No datasource registered with id [" + datasourceIdentifier + "]");
        }
        DataSource ds = (DataSource)this.componentContext.locateService("datasources", sr);
        return ds;
    }

    public void bind(EventAdmin ea) {
        this.ea = ea;
    }

    public void unbind(EventAdmin ea) {
        this.ea = null;
    }

    public void notify(String id, String eventType) {
        HashMap<String, Object> internalEventProperties = new HashMap<String, Object>();
        internalEventProperties.put("_IS_INTERNAL_EVENT", true);
        internalEventProperties.put("_INTERNAL_EVENT_TYPE", eventType);
        internalEventProperties.put("_INTERNAL_EVENT_REFERRING_ID", id);
        Event ev = new Event("SPAGIC/MESSAGES", internalEventProperties);
        if (this.ea != null) {
            this.ea.postEvent(ev);
        }
    }

    @Override
    public Set<String> getRegisteredDatasourcesIDs() {
        return this.datasources.keySet();
    }
}

