/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.core.routing;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.core.SpagicNode;
import org.eclipse.ebpm.core.registry.ISpagicRegistry;
import org.eclipse.ebpm.core.routing.IDynamicRouter;
import org.eclipse.ebpm.core.routing.IMessageRouter;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Status;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpagicRouter
implements IMessageRouter {
    private static Logger logger = LoggerFactory.getLogger(SpagicRouter.class);
    private AtomicReference<EventAdmin> localEventAdmin = new AtomicReference();
    private AtomicReference<EventAdmin> distributedEventAdmin = new AtomicReference();
    private ISpagicRegistry registry = null;
    private IDynamicRouter dynamicRouter = null;

    @Override
    public void send(Exchange exchange) throws Exception {
        String sender = (String)exchange.getProperties().get("SPAGIC_SENDER");
        String target = (String)exchange.getProperties().get("SPAGIC_TARGET");
        logger.info("Spagic Router SEND EXCHANGE [" + exchange.getId() + "] [" + sender + "] [" + target + "] Status [" + exchange.getStatus().toString() + "]");
        String correlationId = (String)exchange.getProperty("CORRELATION_ID");
        if (correlationId == null) {
            correlationId = UUID.randomUUID().toString();
            exchange.setProperty("CORRELATION_ID", (Object)correlationId);
        }
        if (target == null) {
            target = this.dynamicRouter.getTarget(sender);
            exchange.setProperty("SPAGIC_TARGET", (Object)target);
        }
        if (target == null) {
            throw new Exception(" No Target Configured ");
        }
        if (!this.registry.isRegistered(target)) {
            String error = "Target Service [" + target + "] for exchange is not registered";
            this.sendBack(exchange, error, sender, target);
        }
        this.route(exchange, target);
    }

    protected String getSenderNode(Exchange exchange) {
        String senderNode = (String)exchange.getProperties().get("EXCHANGE_SENDER_NODE");
        return senderNode;
    }

    protected String getTargetNode(Exchange exchange) {
        String targetNode = (String)exchange.getProperties().get("EXCHANGE_TARGET_NODE");
        return targetNode;
    }

    protected void route(Exchange exchange, String target) {
        logger.debug("SpagicRouter -> route -> Target is -> [" + target + "]");
        EventAdmin ea = null;
        if (this.registry.isRegisteredLocally(target)) {
            logger.debug("SpagicRouter-> route -> Target [" + target + "] is registered locally ");
            logger.debug("SpagicRouter -> route -> Setting Target Node -> [" + SpagicNode.id() + "]");
            exchange.setProperty("EXCHANGE_TARGET_NODE", (Object)SpagicNode.id());
            logger.debug("SpagicRouter -> route -> Getting Local Event Admin");
            ea = this.localEventAdmin.get();
            if (ea == null) {
                logger.debug("SpagicRouter -> route -> Local Event Admin is null -> Getting Distributed Event Admin");
                ea = this.distributedEventAdmin.get();
            }
        } else if (this.registry.isRegistered(target)) {
            String node = this.registry.getServiceNode(target);
            logger.debug("SpagicRouter-> route -> Target [" + target + "] is NOT registered locally BUT on Node [" + node + "]");
            logger.debug("SpagicRouter -> route -> Setting Target Node -> [" + node + "]");
            exchange.setProperty("EXCHANGE_TARGET_NODE", (Object)node);
            logger.debug("SpagicRouter -> route -> Getting Distributed Event Admin");
            ea = this.distributedEventAdmin.get();
            if (ea == null) {
                logger.debug("SpagicRouter -> route -> Distributed Event Admin is null -> Getting Local Event Admin");
                ea = this.localEventAdmin.get();
            }
        }
        logger.debug(" Checking if exchange has a sender Node and if it's different from target Node");
        String senderNode = this.getSenderNode(exchange);
        String targetNode = this.getTargetNode(exchange);
        logger.debug(" Sender Node [" + senderNode + "] -- Target Node [" + targetNode + "]");
        if (senderNode != null && !senderNode.equalsIgnoreCase(targetNode)) {
            logger.debug("SpagicRouter -> Forced to use Distributed Event Admin");
            exchange.setProperty("EXCHANGE_TARGET_NODE", (Object)senderNode);
            ea = this.distributedEventAdmin.get();
            if (ea == null) {
                ea = this.distributedEventAdmin.get();
            }
        }
        if (ea != null) {
            ea.postEvent(ExchangeUtils.toEvent(exchange));
        }
    }

    protected void sendBack(Exchange exchange, String errorMessage, String originalSender, String originalTarget) {
        if (exchange.getStatus() != Status.Done) {
            exchange.setProperty("SPAGIC_SENDER", (Object)"SPAGIC_ROUTER");
            exchange.setProperty("SPAGIC_TARGET", (Object)originalSender);
            if (ExchangeUtils.isInAndOut(exchange)) {
                exchange.getFault().setBody("<error>" + errorMessage + "</error>");
            } else {
                exchange.setError(new Exception(errorMessage));
            }
            this.route(exchange, originalSender);
            return;
        }
    }

    public void bindLocalEventAdmin(EventAdmin ea) {
        this.localEventAdmin.set(ea);
    }

    public void unbindLocalEventAdmin(EventAdmin ea) {
        this.localEventAdmin.compareAndSet(ea, null);
    }

    public void bindDistributedEventAdmin(EventAdmin ea) {
        this.distributedEventAdmin.set(ea);
    }

    public void unbindDistributedEventAdmin(EventAdmin ea) {
        this.distributedEventAdmin.compareAndSet(ea, null);
    }

    public boolean isDistributedEventAdmin(ServiceReference sr) {
        String eaType = (String)sr.getProperty("eaType");
        if (eaType == null) {
            return false;
        }
        return eaType.equalsIgnoreCase("distributed");
    }

    public void unbindRegistry(ISpagicRegistry spagicRegistry) {
        this.registry = null;
    }

    public void bindRegistry(ISpagicRegistry spagicRegistry) {
        this.registry = spagicRegistry;
    }

    public void bindDynamicRouter(IDynamicRouter dr) {
        this.dynamicRouter = dr;
    }

    public void unbindDynamicRouter(IDynamicRouter dr) {
        this.dynamicRouter = null;
    }

    @Override
    public boolean isServiceRegistered(String target) throws Exception {
        return this.registry.isRegistered(target);
    }
}

