/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.graph.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.eclipse.ebpm.graph.parser.IProcessInfo;
import org.eclipse.ebpm.graph.parser.StepInfo;
import org.eclipse.ebpm.graph.parser.SubProcessInfo;
import org.eclipse.ebpm.xmlutil.DOM4JUtils;
import org.eclipse.ebpm.xmlutil.EXMLUtils;
import org.eclipse.ebpm.xmlutil.MapNamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SvgParser {
    long _processId;
    long _processInstanceId;
    org.w3c.dom.Document _svgDocument = null;
    EXMLUtils xmlUtils = null;
    IProcessInfo _processInfo = null;
    private static final Log log = LogFactory.getLog(SvgParser.class);
    private Map<String, String> namespaceMap = null;
    public static final String NODE_LABEL = "node";
    public static final String EDGE_LABEL = "edge";
    public static final String FONT_SIZE = "font-size".intern();
    public static final String FONT_SIZE_VALUE = "6.00".intern();

    public SvgParser(long processId, String svg, IProcessInfo processInfo) throws Exception {
        this._processId = processId;
        this._processInfo = processInfo;
        this.initInputSvgBean(svg);
    }

    public SvgParser(long processId, long processInstanceId, String svg, IProcessInfo processInfo) throws Exception {
        this._processId = processId;
        this._processInstanceId = processInstanceId;
        this._processInfo = processInfo;
        this.initInputSvgBean(svg);
    }

    private void initInputSvgBean(String roughSvg) throws Exception {
        SAXReader reader = new SAXReader();
        ByteArrayInputStream is = new ByteArrayInputStream(roughSvg.getBytes());
        this._svgDocument = DOM4JUtils.dom4j_to_dom((Document)reader.read((InputStream)is));
        this.namespaceMap = new HashMap<String, String>();
        this.namespaceMap.put("svg", "http://www.w3.org/2000/svg");
        this.namespaceMap.put("xlink", "http://www.w3.org/1999/xlink");
        this.xmlUtils = new EXMLUtils((NamespaceContext)new MapNamespaceContext(this.namespaceMap));
    }

    public List<Element> getElementsFromSVGFilteredByAttributeValue(String xpath, String attributeName, String attributeValue) throws XPathException {
        ArrayList<Element> nodes = new ArrayList<Element>();
        Element root = this.xmlUtils.selectNode((Node)this._svgDocument, "/svg:svg");
        List elements = this.xmlUtils.selectNodes((Node)root, xpath);
        if (elements.size() == 0) {
            return nodes;
        }
        for (Element element : elements) {
            if (element.getAttribute(attributeName).compareTo(attributeValue) != 0) continue;
            nodes.add(element);
        }
        return nodes;
    }

    public String createProcessSvgString() throws Exception {
        Document svgDocDom4j = null;
        try {
            Element svg = this.xmlUtils.selectNode((Node)this._svgDocument, "/svg:svg");
            String width = svg.getAttribute("width");
            svg.setAttribute("width", this.getBiggerWidth(width));
            List<Element> elementList = this.getElementsFromSVGFilteredByAttributeValue("//svg:g/svg:g", "class", NODE_LABEL);
            String stepName = null;
            for (Element element : elementList) {
                SubProcessInfo subProcess;
                Element a = this.xmlUtils.selectNode((Node)element, "svg:a");
                a.setAttribute("xlink:href", "javascript:void(0)");
                Element svgTitleEl = this.xmlUtils.selectNode((Node)element, "svg:title");
                stepName = this.xmlUtils.getText((Node)svgTitleEl);
                Element textEl = this.xmlUtils.selectNode((Node)element, "svg:a/svg:text");
                if (stepName == null || stepName == "") {
                    stepName = this.xmlUtils.getText((Node)textEl);
                }
                String y = textEl.getAttribute("y");
                this.modifyCoordinateNextText(y);
                StepInfo step = this._processInfo.getStepInfo(stepName);
                String originalName = step.getOriginalStepName();
                element.setAttribute("id", stepName);
                String decoratedStepName = this.decorateStepName(originalName);
                int dotPos = decoratedStepName.indexOf(46);
                if (dotPos != -1) {
                    decoratedStepName = decoratedStepName.substring(dotPos + 1);
                }
                textEl.setTextContent(decoratedStepName);
                if (textEl.hasAttribute("style")) {
                    textEl.setAttribute("style", "font-size:6.00pt;");
                } else if (textEl.hasAttribute(FONT_SIZE)) {
                    textEl.setAttribute(FONT_SIZE, FONT_SIZE_VALUE);
                } else {
                    textEl.setAttribute(FONT_SIZE, FONT_SIZE_VALUE);
                }
                textEl.setAttribute("title", "Step");
                textEl.setAttribute("onclick", "showDetail(evt, " + step.getStepID() + ");");
                if (step.isStartStep() && this._processInstanceId == 0L && step.getStepState() == 1) {
                    this.changeNodeState(-5, element);
                }
                if ((subProcess = this._processInfo.getSubProcessInfo(stepName)) == null) continue;
                Element newText = this._svgDocument.createElement("text");
                newText.setAttribute("style", textEl.getAttribute("style"));
                newText.setAttribute("text-anchor", textEl.getAttribute("text-anchor"));
                newText.setAttribute("x", textEl.getAttribute("x"));
                Double subProcessCoordinate = Double.parseDouble(textEl.getAttribute("y")) + 10.0;
                newText.setAttribute("y", subProcessCoordinate.toString());
                newText.setAttribute("onclick", "showSubProcess(evt, " + subProcess.getId() + ", " + step.getStepID() + ");");
                newText.setTextContent(subProcess.getName());
                this.changeStyle("font-style:", "italic", newText);
                newText.setAttribute("title", "SubProcess");
                a.appendChild(newText);
            }
            svgDocDom4j = DOM4JUtils.dom_to_dom4j((org.w3c.dom.Document)this._svgDocument);
            org.dom4j.Element script = svgDocDom4j.getRootElement().addElement("script");
            this.setCDATABean(script);
            this._svgDocument = DOM4JUtils.dom4j_to_dom((Document)svgDocDom4j);
        }
        catch (Exception sbe) {
            log.error((Object)"SvgParser::createProcessSvgString: ", (Throwable)sbe);
            throw sbe;
        }
        return svgDocDom4j.asXML();
    }

    private String decorateStepName(String stepName) {
        int versionPos;
        int dotPos = stepName.indexOf(46);
        if (dotPos != -1) {
            stepName = stepName.substring(dotPos + 1);
        }
        if ((versionPos = stepName.indexOf("_v_")) != -1) {
            stepName = stepName.substring(0, versionPos);
        }
        return stepName;
    }

    private void modifyCoordinateNextText(String value) throws Exception {
        List<Element> textList = this.getElementsFromSVGFilteredByAttributeValue("//svg:g/svg:g/svg:a/svg:text", "y", value);
        try {
            if (textList.size() > 1) {
                double startY = Double.parseDouble(value);
                double distance = 6.0;
                int counter = 0;
                for (Element elem : textList) {
                    switch (counter) {
                        case 0: {
                            ++counter;
                            elem.setAttribute("y", Double.toString(startY));
                            break;
                        }
                        case 1: {
                            ++counter;
                            elem.setAttribute("y", Double.toString(startY - distance));
                            break;
                        }
                        case 2: {
                            counter = 0;
                            elem.setAttribute("y", Double.toString(startY + distance));
                        }
                    }
                }
            }
        }
        catch (Exception sbe) {
            log.error((Object)"SvgParser::modifyCoordinateNextText: ", (Throwable)sbe);
            throw sbe;
        }
    }

    private void setCDATABean(org.dom4j.Element script) throws Exception {
        try {
            script.addAttribute("type", "text/javascript");
            String functionshowDetailString = "function showDetail(evt, stepId){\n\ttop.showDetailStep(stepId);\n}\n";
            String functionshowSubProcessString = "function showSubProcess(evt, processId, stepId){\n";
            functionshowSubProcessString = this._processInstanceId == 0L ? String.valueOf(functionshowSubProcessString) + "\ttop.showDetailSubProcess('',processId);\n" : String.valueOf(functionshowSubProcessString) + "\ttop.showListSubProcess(stepId);\n";
            functionshowSubProcessString = String.valueOf(functionshowSubProcessString) + "}\n";
            script.setText("\n" + functionshowDetailString + "\n" + functionshowSubProcessString);
        }
        catch (Exception sbe) {
            log.error((Object)"SvgParser::getCDATABean: ", (Throwable)sbe);
            throw sbe;
        }
    }

    private String getBiggerWidth(String width) {
        if (width.indexOf("pt") != -1) {
            String widthTemp = width.substring(0, width.indexOf("pt"));
            int newWidth = Integer.parseInt(widthTemp) + 70;
            return String.valueOf(Integer.toString(newWidth)) + "pt";
        }
        String widthTemp = width.substring(0, width.indexOf("in"));
        double newWidth = Double.parseDouble(widthTemp) + 2.0;
        return String.valueOf(Double.toString(newWidth)) + "in";
    }

    public String createProcessInstanceSvgString() throws Exception {
        this.createProcessSvgString();
        List<Element> elementList = this.getElementsFromSVGFilteredByAttributeValue("//svg:g/svg:g", "class", NODE_LABEL);
        for (Element element : elementList) {
            Element titleEl = this.xmlUtils.selectNode((Node)element, "svg:title");
            String stepName = this.xmlUtils.getText((Node)titleEl);
            Element textEl = this.xmlUtils.selectNode((Node)element, "svg:a/svg:text");
            if (stepName == null || stepName == "") {
                stepName = this.xmlUtils.getText((Node)textEl);
            }
            int stateInstanceService = this._processInfo.getExecutionStateInstanceService(stepName, this._processInstanceId);
            this.changeNodeState(stateInstanceService, element);
        }
        return DOM4JUtils.dom_to_dom4j((org.w3c.dom.Document)this._svgDocument).asXML();
    }

    private void changeNodeState(int state, Element element) throws Exception {
        String newColor = null;
        switch (state) {
            case -2: {
                newColor = "#99FF99";
                break;
            }
            case -3: {
                newColor = "#FFFF99";
                break;
            }
            case -5: {
                newColor = "red";
                break;
            }
            case -4: {
                newColor = "#FFA500";
            }
        }
        if (newColor == null) {
            return;
        }
        Element shape = this.xmlUtils.selectNode((Node)element, "svg:a/svg:polygon");
        if (shape != null) {
            List nodeList = this.xmlUtils.selectNodes((Node)element, "svg:a/svg:path");
            if (nodeList.isEmpty()) {
                this.changeFillColor(newColor, shape);
            } else {
                this.changeFillColor(newColor, shape);
                this.changeStrokeColor(newColor, shape);
                for (Element polyLine : nodeList) {
                    this.changeFillColor(newColor, polyLine);
                }
            }
        } else {
            shape = this.xmlUtils.selectNode((Node)element, "svg:a/svg:ellipse");
            if (shape != null) {
                this.changeFillColor(newColor, shape);
            }
        }
    }

    private void changeFillColor(String newColor, Element node) throws Exception {
        this.changeStyle("fill:", newColor, node);
    }

    private void changeStrokeColor(String newColor, Element node) throws Exception {
        this.changeStyle("stroke:", newColor, node);
    }

    private void changeStyle(String attribute, String newStyle, Element node) throws Exception {
        String style;
        Attr styleAttr = node.getAttributeNode("style");
        String string = style = styleAttr != null ? styleAttr.getValue() : null;
        if (style != null) {
            int attributePos = style.indexOf(attribute);
            if (attributePos != -1) {
                int attributeEndPos = style.indexOf(59, attributePos);
                style = String.valueOf(style.substring(0, attributePos)) + attribute + newStyle + style.substring(attributeEndPos);
            } else {
                style = String.valueOf(style) + attribute + newStyle + ";";
            }
            try {
                node.setAttribute("style", style);
            }
            catch (Exception e) {
                log.error((Object)"SvgParser::changeColor: ", (Throwable)e);
                throw e;
            }
        } else if (attribute.startsWith("fill")) {
            node.setAttribute("fill", newStyle);
        } else if (attribute.startsWith("stroke")) {
            node.setAttribute("stroke", newStyle);
        }
    }

    public int getPosXOffset() {
        Element svg = null;
        try {
            svg = this.xmlUtils.selectNode((Node)this._svgDocument, "/svg:svg");
        }
        catch (Exception sbe) {
            log.error((Object)"SvgParser::getPosXOffset: ", (Throwable)sbe);
        }
        String width = svg.getAttribute("width");
        int graphWidthDefaultOffset = 600;
        String widthTemp = width.substring(0, width.indexOf("pt"));
        if (Integer.parseInt(widthTemp) + 250 > graphWidthDefaultOffset) {
            graphWidthDefaultOffset = Integer.parseInt(widthTemp) + 250;
        }
        return graphWidthDefaultOffset;
    }
}

