/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice.generic;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.jobs.JobsExecutor;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.provider.remoteservice.Messages;
import org.eclipse.ecf.provider.remoteservice.generic.RegistrySharedObject;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceRegistrationImpl;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceException;

public class RemoteServiceImpl
implements IRemoteService,
InvocationHandler {
    protected static final long DEFAULT_TIMEOUT = new Long(System.getProperty("ecf.remotecall.timeout", "30000"));
    protected RemoteServiceRegistrationImpl registration = null;
    protected RegistrySharedObject sharedObject = null;
    static /* synthetic */ Class class$0;

    public RemoteServiceImpl(RegistrySharedObject sharedObject, RemoteServiceRegistrationImpl registration) {
        this.sharedObject = sharedObject;
        this.registration = registration;
    }

    public void callAsync(IRemoteCall call, IRemoteCallListener listener) {
        this.sharedObject.sendCallRequestWithListener(this.registration, call, listener);
    }

    public IFuture callAsync(final IRemoteCall call) {
        JobsExecutor executor = new JobsExecutor(NLS.bind((String)"callAsynch({0}", (Object)call.getMethod()));
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return RemoteServiceImpl.this.callSync(call);
            }
        }, null);
    }

    public Object callSync(IRemoteCall call) throws ECFException {
        return this.sharedObject.callSynch(this.registration, call);
    }

    public void fireAsync(IRemoteCall call) throws ECFException {
        this.sharedObject.sendFireRequest(this.registration, call);
    }

    public Object getProxy() throws ECFException {
        Object proxy;
        try {
            String[] clazzes = this.registration.getClasses();
            Class[] cs = new Class[clazzes.length + 1];
            int i = 0;
            while (i < clazzes.length) {
                cs[i] = Class.forName(clazzes[i]);
                ++i;
            }
            int n = clazzes.length;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            cs[n] = clazz;
            proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), cs, (InvocationHandler)this);
        }
        catch (Exception e) {
            throw new ECFException(Messages.RemoteServiceImpl_EXCEPTION_CREATING_PROXY, (Throwable)e);
        }
        return proxy;
    }

    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        try {
            if (method.getName().equals("toString")) {
                String[] clazzes = this.registration.getClasses();
                String proxyClass = clazzes.length == 1 ? clazzes[0] : Arrays.asList(clazzes).toString();
                return String.valueOf(proxyClass) + ".proxy@" + this.registration.getID();
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("equals")) {
                if (args == null || args.length == 0) {
                    return Boolean.FALSE;
                }
                try {
                    return new Boolean(Proxy.getInvocationHandler(args[0]).equals(this));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return Boolean.FALSE;
                }
            }
            if (method.getName().equals("getRemoteService")) {
                return this;
            }
            return this.callSync(new IRemoteCall(){

                public String getMethod() {
                    return method.getName();
                }

                public Object[] getParameters() {
                    return args;
                }

                public long getTimeout() {
                    return DEFAULT_TIMEOUT;
                }
            });
        }
        catch (Throwable t) {
            throw new ServiceException("Service exception on remote service proxy rsid=" + this.registration.getID(), 5, t);
        }
    }
}

