/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.jms.marshaler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Map;
import javax.activation.DataHandler;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.ebpm.connectors.jms.marshaler.BaseJmsMarshaler;
import org.eclipse.ebpm.connectors.jms.marshaler.JmsConsumerMarshaler;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Pattern;
import org.eclipse.ebpm.soap.api.Interceptor;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.core.MessageImpl;
import org.eclipse.ebpm.soap.core.PhaseInterceptorChain;
import org.eclipse.ebpm.soap.interceptors.mime.AttachmentsInInterceptor;
import org.eclipse.ebpm.soap.interceptors.mime.AttachmentsOutInterceptor;
import org.eclipse.ebpm.soap.interceptors.xml.BodyOutInterceptor;
import org.eclipse.ebpm.soap.interceptors.xml.StaxInInterceptor;
import org.eclipse.ebpm.soap.interceptors.xml.StaxOutInterceptor;

public class DefaultConsumerMarshaler
extends BaseJmsMarshaler
implements JmsConsumerMarshaler {
    private Pattern mep;
    private boolean rollbackOnError;
    private boolean rollbackOnErrorDefault;
    private boolean rollbackConfigured;

    public DefaultConsumerMarshaler() {
        this.mep = Pattern.InOnly;
    }

    public DefaultConsumerMarshaler(Pattern mep) {
        this.mep = mep;
    }

    public Pattern getMep() {
        return this.mep;
    }

    public void setMep(Pattern mep) {
        this.mep = mep;
    }

    public boolean isRollbackOnError() {
        return this.rollbackConfigured ? this.rollbackOnError : this.rollbackOnErrorDefault;
    }

    public void setRollbackOnError(boolean rollbackOnError) {
        this.rollbackConfigured = true;
        this.rollbackOnError = rollbackOnError;
    }

    public void setRollbackOnErrorDefault(boolean rollbackDefault) {
        this.rollbackOnErrorDefault = rollbackDefault;
    }

    @Override
    public Exchange createExchange(javax.jms.Message message) throws Exception {
        Exchange exchange = ExchangeUtils.createExchange((Pattern)this.mep);
        org.eclipse.ebpm.messaging.api.Message inMessage = exchange.getIn();
        this.populateMessage(message, inMessage);
        if (this.isCopyProperties()) {
            this.copyPropertiesFromJMSMessage(message, inMessage);
        }
        return exchange;
    }

    @Override
    public javax.jms.Message createOut(Exchange exchange, org.eclipse.ebpm.messaging.api.Message outMsg, Session session) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PhaseInterceptorChain chain = new PhaseInterceptorChain();
        chain.add((Interceptor)new AttachmentsOutInterceptor());
        chain.add((Interceptor)new StaxOutInterceptor());
        chain.add((Interceptor)new BodyOutInterceptor());
        MessageImpl msg = new MessageImpl();
        msg.setContent(Source.class, (Object)outMsg.getBody());
        msg.setContent(OutputStream.class, (Object)baos);
        for (String attId : outMsg.getAttachments().keySet()) {
            msg.getAttachments().put(attId, (DataHandler)outMsg.getAttachment(attId));
        }
        chain.doIntercept((Message)msg);
        TextMessage text = session.createTextMessage(baos.toString());
        if (msg.get((Object)"Content-Type") != null) {
            text.setStringProperty("SOAPJMS_contentType", (String)msg.get((Object)"Content-Type"));
        }
        if (this.isCopyProperties()) {
            this.copyPropertiesFromNormalizedMessage(outMsg, (javax.jms.Message)text);
        }
        return text;
    }

    @Override
    public javax.jms.Message createFault(Exchange exchange, org.eclipse.ebpm.messaging.api.Message fault, Session session) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PhaseInterceptorChain chain = new PhaseInterceptorChain();
        chain.add((Interceptor)new AttachmentsOutInterceptor());
        chain.add((Interceptor)new StaxOutInterceptor());
        chain.add((Interceptor)new BodyOutInterceptor());
        MessageImpl msg = new MessageImpl();
        msg.setContent(Source.class, (Object)fault.getBody());
        msg.setContent(OutputStream.class, (Object)baos);
        for (String attId : fault.getAttachments().keySet()) {
            msg.getAttachments().put(attId, (DataHandler)fault.getAttachment(attId));
        }
        chain.doIntercept((Message)msg);
        TextMessage text = session.createTextMessage(baos.toString());
        if (msg.get((Object)"Content-Type") != null) {
            text.setStringProperty("SOAPJMS_contentType", (String)msg.get((Object)"Content-Type"));
        }
        if (this.isCopyProperties()) {
            this.copyPropertiesFromNormalizedMessage(fault, (javax.jms.Message)text);
        }
        return text;
    }

    @Override
    public javax.jms.Message createError(Exchange exchange, Exception error, Session session) throws Exception {
        if (this.rollbackOnError) {
            throw error;
        }
        ObjectMessage message = session.createObjectMessage((Serializable)error);
        return message;
    }

    protected void populateMessage(javax.jms.Message message, org.eclipse.ebpm.messaging.api.Message normalizedMessage) throws Exception {
        if (message instanceof TextMessage) {
            PhaseInterceptorChain chain = new PhaseInterceptorChain();
            chain.add((Interceptor)new AttachmentsInInterceptor());
            chain.add((Interceptor)new StaxInInterceptor());
            MessageImpl msg = new MessageImpl();
            msg.setContent(InputStream.class, (Object)new ByteArrayInputStream(((TextMessage)message).getText().getBytes()));
            if (message.propertyExists("SOAPJMS_contentType")) {
                msg.put((Object)"Content-Type", (Object)message.getStringProperty("SOAPJMS_contentType"));
            }
            chain.doIntercept((Message)msg);
            XMLStreamReader xmlReader = (XMLStreamReader)msg.getContent(XMLStreamReader.class);
            StAXSource src = new StAXSource(xmlReader);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer xform = tfactory.newTransformer();
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            xform.transform(src, result);
            normalizedMessage.setBody(writer.toString());
            for (Map.Entry attachment : msg.getAttachments().entrySet()) {
                normalizedMessage.addAttachment((String)attachment.getKey(), attachment.getValue());
            }
        } else {
            throw new UnsupportedOperationException("JMS message is not a TextMessage");
        }
    }
}

