/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.channel;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.jms.Activator;
import org.eclipse.ecf.provider.comm.AsynchEvent;
import org.eclipse.ecf.provider.comm.ConnectionEvent;
import org.eclipse.ecf.provider.comm.DisconnectEvent;
import org.eclipse.ecf.provider.comm.IAsynchConnection;
import org.eclipse.ecf.provider.comm.IConnection;
import org.eclipse.ecf.provider.comm.IConnectionListener;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchEventHandler;
import org.eclipse.ecf.provider.jms.channel.ECFMessage;
import org.eclipse.ecf.provider.jms.channel.JMSMessage;
import org.eclipse.ecf.provider.jms.channel.JmsTopic;
import org.eclipse.ecf.provider.jms.channel.SynchRequestMessage;
import org.eclipse.ecf.provider.jms.channel.SynchResponseMessage;
import org.eclipse.ecf.provider.jms.identity.JMSID;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractJMSChannel
extends SocketAddress
implements ISynchAsynchConnection {
    private static final long serialVersionUID = 4516462369458730752L;
    private static long correlationID = 0L;
    protected Connection connection = null;
    protected Session session = null;
    protected JmsTopic jmsTopic = null;
    protected ID localContainerID;
    protected boolean connected = false;
    private boolean started = false;
    protected ISynchAsynchEventHandler handler;
    protected int keepAlive = -1;
    private Map properties = new HashMap();
    protected List connectionListeners = new ArrayList();
    protected boolean isStopping = false;
    protected Object synch = new Object();
    private String correlation = null;
    private Serializable reply = null;
    private boolean waitDone;

    public AbstractJMSChannel(ISynchAsynchEventHandler hand, int keepAlive) {
        this.handler = hand;
        Assert.isNotNull((Object)this.handler);
        this.localContainerID = hand.getEventHandlerID();
        Assert.isNotNull((Object)this.localContainerID);
        this.keepAlive = keepAlive;
    }

    public abstract Object connect(ID var1, Object var2, int var3) throws ECFException;

    public abstract Object sendSynch(ID var1, byte[] var2) throws IOException;

    protected abstract ConnectionFactory createJMSConnectionFactory(JMSID var1) throws IOException;

    protected abstract void handleSynchRequest(ObjectMessage var1, ECFMessage var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireListenersConnect(ConnectionEvent event) {
        ArrayList toNotify = null;
        List list = this.connectionListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.connectionListeners);
        }
        for (IConnectionListener l : toNotify) {
            l.handleConnectEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireListenersDisconnect(ConnectionEvent event) {
        ArrayList toNotify = null;
        List list = this.connectionListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.connectionListeners);
        }
        for (IConnectionListener l : toNotify) {
            l.handleConnectEvent(event);
        }
    }

    public ID getLocalID() {
        return this.localContainerID;
    }

    private static long getNextCorrelationID() {
        return correlationID++;
    }

    protected boolean isActive() {
        return this.isConnected() && this.isStarted() && !this.isStopping();
    }

    protected void onJMSException(JMSException except) {
        if (this.isActive()) {
            this.handler.handleDisconnectEvent(new DisconnectEvent((IAsynchConnection)this, (Throwable)except, null));
        }
    }

    protected boolean isStopping() {
        return this.isStopping;
    }

    protected Serializable createConnectRequestData(Object data) {
        if (data instanceof Serializable) {
            return (Serializable)data;
        }
        return null;
    }

    protected Serializable setupJMS(JMSID targetID, Object data) throws ECFException {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"setupJMS");
        try {
            ConnectionFactory factory = this.createJMSConnectionFactory(targetID);
            this.connection = factory.createConnection();
            this.connection.setClientID(this.getLocalID().getName());
            this.connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException arg0) {
                    AbstractJMSChannel.this.onJMSException(arg0);
                }
            });
            this.session = this.connection.createSession(false, 1);
            this.jmsTopic = new JmsTopic(this.session, targetID.getTopic());
            this.jmsTopic.getConsumer().setMessageListener((MessageListener)new TopicReceiver());
            this.connected = true;
            this.isStopping = false;
            this.connection.start();
            Serializable connectData = this.createConnectRequestData(data);
            Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"setup", (Object)connectData);
            return connectData;
        }
        catch (Exception e) {
            this.disconnect();
            throw new ECFException("JMS Connect or Setup Exception", (Throwable)e);
        }
    }

    public void sendAsynch(ID recipient, Object obj) throws IOException {
        this.queueObject(recipient, (Serializable)obj);
    }

    public void sendAsynch(ID recipient, byte[] obj) throws IOException {
        this.queueObject(recipient, (Serializable)obj);
    }

    private void queueObject(ID recipient, Serializable obj) throws IOException {
        if (!this.isActive()) {
            throw new ConnectException("Not connected");
        }
        try {
            this.jmsTopic.getProducer().send((Message)this.session.createObjectMessage((Serializable)new JMSMessage(this.getConnectionID(), this.getLocalID(), recipient, obj)));
        }
        catch (JMSException e) {
            this.throwIOException("queueObject", "Exception in queueObject", e);
        }
    }

    protected void onTopicException(JMSException except) {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"onTopicException", (Object[])new Object[]{except});
        if (this.isActive()) {
            this.handler.handleDisconnectEvent(new DisconnectEvent((IAsynchConnection)this, (Throwable)except, null));
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"onTopicException");
    }

    protected void throwIOException(String method, String msg, Throwable t) throws IOException {
        Trace.throwing((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/exceptions/catching", this.getClass(), (String)method, (Throwable)t);
        throw new IOException(String.valueOf(msg) + ": " + t.getMessage());
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void addListener(IConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeListener(IConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"disconnect");
        Object object = this.synch;
        synchronized (object) {
            this.stop();
            this.connected = false;
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception e) {
                    Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.jms", 4, "connection close", (Throwable)e));
                }
                this.connection = null;
            }
            this.synch.notifyAll();
        }
        this.fireListenersDisconnect(new ConnectionEvent((IConnection)this, null));
        this.connectionListeners.clear();
    }

    public void stop() {
        this.started = false;
    }

    public void start() {
        this.started = true;
    }

    protected void handleTopicMessage(Message msg, JMSMessage jmsmsg) {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"handleTopicMessage", (Object[])new Object[]{msg, jmsmsg});
        if (this.isActive()) {
            try {
                Serializable o = jmsmsg.getData();
                this.handler.handleAsynchEvent(new AsynchEvent((IAsynchConnection)this, (Object)o));
            }
            catch (IOException e) {
                Trace.catching((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/exceptions/catching", this.getClass(), (String)"handleTopicMessage", (Throwable)e);
                Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.jms", 4, "Exception on handleTopicMessage", (Throwable)e));
            }
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"handleTopicMessage");
    }

    protected Serializable sendAndWait(Serializable obj) throws IOException {
        return this.sendAndWait(obj, this.keepAlive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Serializable sendAndWait(Serializable obj, int waitDuration) throws IOException {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"sendAndWait", (Object[])new Object[]{obj, new Integer(waitDuration)});
        Object object = this.synch;
        synchronized (object) {
            try {
                ObjectMessage msg = this.session.createObjectMessage(obj);
                this.correlation = String.valueOf(AbstractJMSChannel.getNextCorrelationID());
                msg.setJMSCorrelationID(this.correlation);
                this.waitDone = false;
                long waittimeout = System.currentTimeMillis() + (long)waitDuration;
                this.reply = null;
                this.jmsTopic.getProducer().send((Message)msg);
                while (!this.waitDone && waittimeout - System.currentTimeMillis() > 0L) {
                    this.synch.wait(waitDuration / 10);
                }
                this.waitDone = true;
                if (this.reply == null) {
                    throw new IOException("timeout waiting for response");
                }
            }
            catch (JMSException e) {
                Trace.catching((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/exceptions/catching", this.getClass(), (String)"sendAndWait", (Throwable)e);
                this.throwIOException("sendAndWait", "JMSException in sendAndWait", e);
            }
            catch (InterruptedException e) {
                this.traceAndLogExceptionCatch(4, "handleTopicMessage", e);
            }
            Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"sendAndWait", (Object)this.reply);
            return this.reply;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSynchResponse(ObjectMessage msg, ECFMessage ecfmsg) {
        Trace.entering((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"handleSynchMessage", (Object[])new Object[]{msg, ecfmsg});
        Object object = this.synch;
        synchronized (object) {
            if (this.correlation == null) {
                return;
            }
            try {
                if (this.correlation.equals(msg.getJMSCorrelationID())) {
                    this.reply = msg.getObject();
                    this.waitDone = true;
                    this.synch.notify();
                }
            }
            catch (JMSException e) {
                this.traceAndLogExceptionCatch(4, "handleSynchMessage", e);
            }
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/exiting", this.getClass(), (String)"handleSynchMessage");
    }

    protected void traceAndLogExceptionCatch(int code, String method, Throwable e) {
        Trace.catching((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/exceptions/catching", this.getClass(), (String)method, (Throwable)e);
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.jms", code, method, e));
    }

    protected String getConnectionID() {
        String res = null;
        try {
            res = this.connection.getClientID();
            if (res == null) {
                res = this.getLocalID().getName();
            }
            return res;
        }
        catch (Exception e) {
            this.traceAndLogExceptionCatch(4, "getConnectionID", e);
            return null;
        }
    }

    protected final class TopicReceiver
    implements MessageListener {
        public void onMessage(Message msg) {
            try {
                if (msg instanceof ObjectMessage) {
                    ObjectMessage omg = (ObjectMessage)msg;
                    Serializable o = omg.getObject();
                    if (o instanceof ECFMessage) {
                        ECFMessage ecfmsg = (ECFMessage)o;
                        ID fromID = ecfmsg.getSenderID();
                        if (fromID == null) {
                            Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"onMessage.fromID=null");
                            return;
                        }
                        if (fromID.equals((Object)AbstractJMSChannel.this.getLocalID())) {
                            Trace.exiting((String)"org.eclipse.ecf.provider.jms", (String)"org.eclipse.ecf.provider.jms/debug/methods/entering", this.getClass(), (String)"onMessage.fromID=localID IGNORING");
                            return;
                        }
                        ID targetID = ecfmsg.getTargetID();
                        if (targetID == null) {
                            if (ecfmsg instanceof JMSMessage) {
                                AbstractJMSChannel.this.handleTopicMessage(msg, (JMSMessage)ecfmsg);
                            } else {
                                Trace.trace((String)"org.eclipse.ecf.provider.jms", (String)"onMessage.received invalid message to group");
                            }
                        } else if (targetID.equals((Object)AbstractJMSChannel.this.getLocalID())) {
                            if (ecfmsg instanceof JMSMessage) {
                                AbstractJMSChannel.this.handleTopicMessage(msg, (JMSMessage)ecfmsg);
                            } else if (ecfmsg instanceof SynchRequestMessage) {
                                AbstractJMSChannel.this.handleSynchRequest(omg, ecfmsg);
                            } else if (ecfmsg instanceof SynchResponseMessage) {
                                AbstractJMSChannel.this.handleSynchResponse(omg, ecfmsg);
                            } else {
                                Trace.trace((String)"org.eclipse.ecf.provider.jms", (String)NLS.bind((String)"onMessage.msg invalid message to {0}", (Object)targetID));
                            }
                        }
                    } else {
                        Trace.trace((String)"org.eclipse.ecf.provider.jms", (String)NLS.bind((String)"onMessage received non-ECFMessage...ignoring {0}", (Object)o));
                    }
                } else {
                    Trace.trace((String)"org.eclipse.ecf.provider.jms", (String)NLS.bind((String)"onMessage.non object message received {0}", (Object)msg));
                }
            }
            catch (Exception e) {
                AbstractJMSChannel.this.traceAndLogExceptionCatch(4, "JMSChannel onMessage Exception", e);
            }
        }
    }
}

