/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.metadata;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ebpm.metadata.BaseField;
import org.eclipse.ebpm.metadata.Column;
import org.eclipse.ebpm.metadata.ComboItem;
import org.eclipse.ebpm.metadata.Field;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaDefinition {
    private String name;
    private List<Field> fields;
    private List<Column> columns;

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public static SchemaDefinition parseSchema(String xml) throws ParserConfigurationException, DOMException, IOException, SAXException {
        DocumentBuilderFactory xmlFact = DocumentBuilderFactory.newInstance();
        xmlFact.setNamespaceAware(true);
        DocumentBuilder builder = xmlFact.newDocumentBuilder();
        InputSource source = new InputSource(new StringReader(xml));
        Document document = builder.parse(source);
        SchemaDefinition formDescription = null;
        if (document != null) {
            formDescription = new SchemaDefinition();
            NodeList fieldsXml = document.getFirstChild().getChildNodes();
            ArrayList<Field> fields = null;
            ArrayList<Column> columns = null;
            int maxLen = fieldsXml.getLength();
            int i = 0;
            while (i < maxLen) {
                BaseField baseField = null;
                Node fieldElement = fieldsXml.item(i);
                if (fieldElement instanceof Element) {
                    if (fieldElement.getNodeName().equals("field")) {
                        baseField = new Field();
                        if (fields == null) {
                            fields = new ArrayList<Field>();
                        }
                    } else {
                        baseField = new Column();
                        ((Column)baseField).setEditable(Boolean.parseBoolean(SchemaDefinition.getAttribute(fieldElement, "editable")));
                        if (columns == null) {
                            columns = new ArrayList<Column>();
                        }
                    }
                    baseField.setDefaultValue(SchemaDefinition.getAttribute(fieldElement, "defaultValue"));
                    baseField.setCombo(Boolean.parseBoolean(SchemaDefinition.getAttribute(fieldElement, "combo")));
                    baseField.setMandatory(Boolean.parseBoolean(SchemaDefinition.getAttribute(fieldElement, "mandatory")));
                    baseField.setType(SchemaDefinition.getAttribute(fieldElement, "type"));
                    String validator = SchemaDefinition.getAttribute(fieldElement, "validator");
                    if ("None".equals(validator)) {
                        baseField.setValidator(".*");
                    } else if ("Number".equals(validator)) {
                        baseField.setValidator("[\\d\\.\\,]*");
                    } else if ("Text".equals(validator)) {
                        baseField.setValidator("[a-zA-Z \\.\\,\\:\\;]*");
                    } else if ("Number & Text".equals(validator)) {
                        baseField.setValidator("\\w*");
                    } else if ("Telephone Number".equals(validator)) {
                        baseField.setValidator("\\+{0,1}\\d{10,14}");
                    } else if ("E-mail".equals(validator)) {
                        baseField.setValidator("[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}");
                    }
                    baseField.setName(SchemaDefinition.getAttribute(fieldElement, "name"));
                    baseField.setId(SchemaDefinition.getAttribute(fieldElement, "id"));
                    String tmp = SchemaDefinition.getAttribute(fieldElement, "length");
                    if (tmp != null) {
                        baseField.setLength(Integer.parseInt(tmp));
                    }
                    if ((tmp = SchemaDefinition.getAttribute(fieldElement, "precision")) != null) {
                        baseField.setPrecision(Integer.parseInt(tmp));
                    }
                    if (baseField.isCombo()) {
                        Iterator<Node> comboElements = SchemaDefinition.elementIterator(fieldElement, "item");
                        ArrayList<ComboItem> items = null;
                        if (comboElements.hasNext()) {
                            items = new ArrayList<ComboItem>();
                        }
                        while (comboElements.hasNext()) {
                            Node itemElement = comboElements.next();
                            ComboItem item = new ComboItem();
                            item.setLabel(SchemaDefinition.getAttribute(itemElement, "name"));
                            item.setValue(SchemaDefinition.getAttribute(itemElement, "value"));
                            items.add(item);
                        }
                        baseField.setItems(items);
                    }
                    if (fieldElement.getNodeName().equals("field")) {
                        fields.add((Field)baseField);
                    } else {
                        columns.add((Column)baseField);
                    }
                }
                ++i;
            }
            formDescription.setFields(fields);
            formDescription.setColumns(columns);
        }
        return formDescription;
    }

    private static String getAttribute(Node node, String name) throws DOMException {
        return node.getAttributes().getNamedItem(name).getNodeValue();
    }

    private static Iterator<Node> elementIterator(Node node, String name) throws DOMException {
        NodeList nl = node.getChildNodes();
        int maxLen = nl.getLength();
        ArrayList<Node> rvList = new ArrayList<Node>(maxLen);
        int i = 0;
        while (i < maxLen) {
            Node n = nl.item(i);
            if (name.equals(n.getNodeName())) {
                rvList.add(n);
            }
            ++i;
        }
        return rvList.iterator();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

