/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.ftp.locks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class SimpleLock
implements Lock,
Serializable {
    private final Sync sync = new Sync();

    @Override
    public void lock() {
        this.sync.acquire(1);
    }

    @Override
    public boolean tryLock() {
        return this.sync.tryAcquire(1);
    }

    @Override
    public void unlock() {
        this.sync.release(1);
    }

    @Override
    public Condition newCondition() {
        return this.sync.newCondition();
    }

    public boolean isLocked() {
        return this.sync.isHeldExclusively();
    }

    public boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.sync.acquireInterruptibly(1);
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireNanos(1, unit.toNanos(timeout));
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        private Sync() {
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.getState() == 1;
        }

        @Override
        public boolean tryAcquire(int acquires) {
            assert (acquires == 1);
            return this.compareAndSetState(0, 1);
        }

        @Override
        protected boolean tryRelease(int releases) {
            assert (releases == 1);
            if (this.getState() == 0) {
                throw new IllegalMonitorStateException();
            }
            this.setState(0);
            return true;
        }

        Condition newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.setState(0);
        }
    }
}

