/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.components.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.xml.namespace.NamespaceContext;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.dom.DOMDocument;
import org.eclipse.ebpm.components.jdbc.config.JDBCQueryConfig;
import org.eclipse.ebpm.components.jdbc.config.QueryParameterConfig;
import org.eclipse.ebpm.components.jdbc.config.XmlResultSetHandler;
import org.eclipse.ebpm.core.BaseSpagicService;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.datasource.IDataSourceManager;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.util.properties.PropertyConfigurator;
import org.eclipse.ebpm.xmlutil.DOM4JUtils;
import org.eclipse.ebpm.xmlutil.EXMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JDBCComponent
extends BaseSpagicService {
    Logger log = LoggerFactory.getLogger(JDBCComponent.class);
    protected JDBCQueryConfig queryConfig = null;
    protected String dsIdentifier = null;
    protected final AtomicReference<IDataSourceManager> datasourceManager = new AtomicReference<Object>(null);

    public IDataSourceManager getDataSourceManager() {
        return this.datasourceManager.get();
    }

    public void setDataSourceManager(IDataSourceManager dsm) {
        this.datasourceManager.set(dsm);
    }

    public void unsetDataSourceManager(IDataSourceManager dsManager) {
        this.datasourceManager.compareAndSet(dsManager, null);
    }

    public void init() {
        try {
            this.queryConfig = new JDBCQueryConfig();
            this.queryConfig.setQuery(this.propertyConfigurator.getString("query"));
            this.dsIdentifier = this.propertyConfigurator.getString("datasource");
            this.queryConfig.setColumnNameAsAttribute(this.propertyConfigurator.getBoolean("result.columnAsAttribute", Boolean.valueOf(false)));
            this.queryConfig.setRowsXmlEnvelope(this.propertyConfigurator.getString("result.rowsXmlEnvelope", "rows"));
            this.queryConfig.setRowXmlEnvelope(this.propertyConfigurator.getString("result.rowXmlEnvelope", "row"));
            this.queryConfig.setEnrichMessage(this.propertyConfigurator.getBoolean("result.enrichInputMessage", Boolean.valueOf(false)));
            this.queryConfig.setValueAsAttribute(this.propertyConfigurator.getBoolean("result.valueAsAttribute", Boolean.valueOf(false)));
            this.queryConfig.setXmlEnvelope(this.propertyConfigurator.getString("result.xmlEnvelope", ""));
            this.queryConfig.setFaultManagement(this.propertyConfigurator.getString("faultManagement", JDBCQueryConfig.FAULT_SYSTEM));
            Map queryParamsMap = this.propertyConfigurator.getXMapProperty("queryParametersMap");
            Properties pOfParam = null;
            PropertyConfigurator pConfigOfParam = null;
            QueryParameterConfig qpConfig = null;
            ArrayList<QueryParameterConfig> paramList = new ArrayList<QueryParameterConfig>();
            for (String key : queryParamsMap.keySet()) {
                pOfParam = (Properties)queryParamsMap.get(key);
                pConfigOfParam = new PropertyConfigurator(pOfParam);
                qpConfig = new QueryParameterConfig(key, pConfigOfParam.getString("xPathExpression"), pConfigOfParam.getString("parameterType"));
                qpConfig.setOutputParam(pConfigOfParam.getBoolean("outputParam", Boolean.valueOf(false)));
                paramList.add(qpConfig);
            }
            this.queryConfig.setQueryParams(paramList);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public JDBCQueryConfig getQueryConfig() {
        return this.queryConfig;
    }

    public void setQueryConfig(JDBCQueryConfig config) {
        this.queryConfig = config;
    }

    public boolean run(Exchange exchange, Message in, Message out) throws Exception {
        this.log.info("JDBC Component [" + this.getSpagicId() + "] process Exchange Method");
        this.log.info("JDBC Component [" + this.getSpagicId() + "] Retrieving Datasource from Datasource Manager");
        DataSource ds = this.getDataSourceManager().getDataSource(this.dsIdentifier);
        List<String> orderedParameterNameList = this.getStringParameterNames(this.queryConfig.getQuery(), this.queryConfig.getMatchParamRegexp());
        String jdbcQuery = this.queryConfig.getQuery().replaceAll(this.queryConfig.getMatchParamRegexp(), "?");
        ArrayList<QueryParameterConfig> queryParametersConfig = this.queryConfig.getQueryParams();
        Map<String, QueryParameterConfig> parameterConfigMap = this.buildParameterConfigMap(queryParametersConfig);
        Object[] params = this.queryConfig.getParamsFromInXml(in, orderedParameterNameList, parameterConfigMap);
        Connection conn = ds.getConnection();
        org.dom4j.Element results = null;
        try {
            QueryRunner runner = new QueryRunner();
            this.log.debug("Executing query: " + jdbcQuery);
            try {
                String lowerQuery = jdbcQuery.toLowerCase();
                if (lowerQuery.indexOf("delete") != -1 || lowerQuery.indexOf("update") != -1 || lowerQuery.indexOf("insert") != -1) {
                    int intResult = runner.update(conn, jdbcQuery, params);
                    org.dom4j.Element updateResult = DocumentHelper.createElement((String)"affected-rows");
                    updateResult.setText("" + intResult);
                    results = updateResult;
                } else {
                    this.log.debug(" queryConfig.getRowsXmlEnvelope() --> " + this.queryConfig.getRowsXmlEnvelope());
                    this.log.debug(" queryConfig.getRowXmlEnvelope() --> " + this.queryConfig.getRowXmlEnvelope());
                    this.log.debug(" queryConfig.getColumnNameAsAttribute() --> " + this.queryConfig.getColumnNameAsAttribute());
                    this.log.debug(" queryConfig.getValueAsAttribute() " + this.queryConfig.getValueAsAttribute());
                    results = (org.dom4j.Element)runner.query(conn, jdbcQuery, params, (ResultSetHandler)new XmlResultSetHandler(this.queryConfig.getRowsXmlEnvelope(), this.queryConfig.getRowXmlEnvelope(), this.queryConfig.getColumnNameAsAttribute(), this.queryConfig.getValueAsAttribute()));
                }
            }
            catch (SQLException sqle) {
                if (JDBCQueryConfig.FAULT_FLOW.equals(this.queryConfig.getFaultManagement())) {
                    org.dom4j.Element faultElem = DocumentHelper.createElement((String)"Fault");
                    org.dom4j.Element sqlStateElem = DocumentHelper.createElement((String)"sql-state");
                    sqlStateElem.setText(sqle.getSQLState());
                    org.dom4j.Element errorCodeElem = DocumentHelper.createElement((String)"error-code");
                    errorCodeElem.setText("" + sqle.getErrorCode());
                    faultElem.add(sqlStateElem);
                    faultElem.add(errorCodeElem);
                    if (ExchangeUtils.isInAndOut((Exchange)exchange)) {
                        exchange.getFault(true).setBody(faultElem.asXML());
                    }
                    out.setBody(faultElem.asXML());
                    DbUtils.close((Connection)conn);
                    return true;
                }
                throw sqle;
            }
            this.log.debug("Query results: " + results);
        }
        finally {
            DbUtils.close((Connection)conn);
        }
        out.setBody(in.getBody());
        String strContent = in.getBodyText();
        Document docContent = DocumentHelper.parseText((String)strContent);
        NamespaceContext nsContextMap = DOM4JUtils.getNamespaceContext((Document)docContent);
        org.w3c.dom.Document docContentDOM = DOM4JUtils.dom4j_to_dom((Document)docContent);
        EXMLUtils xmlUtils = new EXMLUtils(nsContextMap);
        Element contentEnvelop = null;
        if (this.isValidStr(this.queryConfig.getXmlEnvelope())) {
            contentEnvelop = xmlUtils.selectNode((Node)docContentDOM, "/" + this.queryConfig.getXmlEnvelope());
            if (contentEnvelop == null) {
                this.log.warn("Envelope to enrich not found [/" + this.queryConfig.getXmlEnvelope() + "]: " + "the result will be the original message");
            }
        } else {
            this.log.info("Xml Envelope is null we will keep the original message ");
        }
        if (contentEnvelop != null && this.queryConfig.isEnrichMessage() && this.isValidStr(this.queryConfig.getXmlEnvelope())) {
            this.log.debug("Enriching Original Message, JDBC Result are children of queryConfig.getXmlEnvelope()");
            String resultXML = results.asXML();
            org.w3c.dom.Document resultsDOM = xmlUtils.parseText(resultXML);
            this.log.debug("Appending Results TO XMLEnvelop -> Importing resultDOM");
            Node importedNode = docContentDOM.importNode(resultsDOM.getDocumentElement(), true);
            this.log.debug("Appending Results TO XMLEnvelop -> Adding Imported node as Child of content Envelope");
            contentEnvelop.appendChild(importedNode);
            this.log.debug("Setting Result TO OutMessage " + DOM4JUtils.dom_to_dom4j((org.w3c.dom.Document)docContentDOM).asXML());
            out.setBody(DOM4JUtils.dom_to_dom4j((org.w3c.dom.Document)docContentDOM).asXML());
        } else if (contentEnvelop == null && this.queryConfig.isEnrichMessage()) {
            this.log.debug("Enriching =  true, xmlEnvelope is null -> Keep The Original Message");
            out.setBody(docContent.asXML());
        } else {
            this.log.debug("Not enriching... Keep only the output result");
            docContent = new DOMDocument();
            docContent.add(results);
            out.setBody(docContent.asXML());
        }
        return true;
    }

    public List<String> getStringParameterNames(String propertyValue, String matchRegexp) {
        Pattern pattern = Pattern.compile(matchRegexp);
        Matcher matcher = pattern.matcher(propertyValue);
        ArrayList<String> toReturn = new ArrayList<String>();
        int idx = 1;
        while (matcher.find()) {
            String placeHolder = matcher.group();
            placeHolder = placeHolder.substring(1);
            toReturn.add(placeHolder);
            ++idx;
        }
        return toReturn;
    }

    private Map<String, QueryParameterConfig> buildParameterConfigMap(List<QueryParameterConfig> queryParametersConfig) {
        HashMap<String, QueryParameterConfig> mapParamConfig = new HashMap<String, QueryParameterConfig>();
        for (QueryParameterConfig q : queryParametersConfig) {
            mapParamConfig.put(q.getPlaceHolder(), q);
        }
        return mapParamConfig;
    }

    protected boolean isValidStr(String s) {
        return s != null && s.trim().length() > 0;
    }
}

